/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.key.types;

import java.math.BigInteger;
import java.util.function.Function;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.KeyGeneration;
import tools.cipher.lib.matrix.Matrix;

public class ExtendedMatrixKeyType
implements IKeyType<Matrix> {
    private int mod;

    public ExtendedMatrixKeyType(int mod) {
        this.mod = mod;
    }

    @Override
    public Matrix randomise() {
        return KeyGeneration.createMatrix(2, 1, this.mod);
    }

    @Override
    public boolean iterateKeys(Function<Matrix, Boolean> consumer) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Matrix alterKey(Matrix key) {
        return key;
    }

    @Override
    public boolean isValid(Matrix key) {
        return true;
    }

    @Override
    public String prettifyKey(Matrix key) {
        return key.toString();
    }

    @Override
    public BigInteger getNumOfKeys() {
        BigInteger total = BigInteger.ONE;
        return total;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IKeyType.IKeyBuilder<Matrix> {
        private Builder() {
        }

        public ExtendedMatrixKeyType create() {
            ExtendedMatrixKeyType handler = new ExtendedMatrixKeyType(26);
            return handler;
        }
    }
}

