/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.settings;

import com.alexbarter.ciphertool.base.interfaces.ISettings;
import com.alexbarter.ciphertool.base.settings.SettingCache;
import com.alexbarter.ciphertool.lib.language.ILanguage;
import com.alexbarter.ciphertool.lib.language.Languages;
import java.util.Arrays;
import java.util.List;

public class SettingsCache {
    private static boolean loaded = false;
    public static SettingCache<ILanguage> language;
    public static SettingCache<Boolean> checkShift;
    public static SettingCache<Boolean> checkReverse;
    public static SettingCache<Boolean> checkRoutes;
    public static SettingCache<Boolean> useParallel;
    public static SettingCache<Boolean> updateProgress;
    public static SettingCache<Boolean> collectSolutions;
    public static SettingCache<List<Double>> simulatedAnnealing;
    public static SettingCache<Integer> keywordCreationId;

    public static void onLoad(ISettings settings) {
        language = SettingCache.create(settings, "language", Languages::byName, ILanguage::getName, String.class, Languages.ENGLISH);
        useParallel = SettingCache.create(settings, "use_parallel", true);
        updateProgress = SettingCache.create(settings, "update_progress", true);
        collectSolutions = SettingCache.create(settings, "collect_solutions", false);
        checkShift = SettingCache.create(settings, "check_shift", true);
        checkReverse = SettingCache.create(settings, "check_reverse", true);
        checkRoutes = SettingCache.create(settings, "check_routes", true);
        simulatedAnnealing = SettingCache.create(settings, "simulated_annealing", Arrays.asList(20.0, 0.1, 500.0));
        keywordCreationId = SettingCache.create(settings, "keyword_creation_id", 0);
        loaded = true;
    }
}

