/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.key.types;

import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;

public class EnumKeyType<T extends Enum<T>>
implements IKeyType<T> {
    private final Class<T> enumType;
    private final T[] universe;
    private final boolean alterable;

    private EnumKeyType(Class<T> clazz, T[] universe, boolean alterable) {
        this.enumType = clazz;
        this.universe = universe;
        this.alterable = alterable;
    }

    @Override
    public T randomise() {
        return (T)((Enum)RandomUtil.pickRandomElement((Object[])this.universe));
    }

    @Override
    public boolean isValid(T key) {
        return ArrayUtil.contains((Object[])this.universe, key);
    }

    @Override
    public boolean iterateKeys(Function<T, Boolean> consumer) {
        for (T atom : this.universe) {
            if (consumer.apply(atom).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public BigInteger getNumOfKeys() {
        return BigInteger.valueOf(this.universe.length);
    }

    @Override
    public T alterKey(T key) {
        return (T)(this.alterable ? (Enum)RandomUtil.pickRandomElement((Object[])this.universe) : key);
    }

    @Override
    public T parse(String input) throws ParseException {
        for (T atom : this.universe) {
            if (!((Enum)atom).name().equalsIgnoreCase(input)) continue;
            return atom;
        }
        throw new ParseException(input, 0);
    }

    @Override
    public String getHelp() {
        StringJoiner joiner = new StringJoiner("|");
        for (T atom : this.universe) {
            joiner.add(((Enum)atom).name());
        }
        return joiner.toString();
    }

    public Class<T> getType() {
        return this.enumType;
    }

    public static <T extends Enum<T>> Builder<T> builder(Class<T> enumType) {
        return new Builder(enumType);
    }

    public static class Builder<T extends Enum<T>>
    implements IKeyType.IKeyBuilder<T> {
        private Class<T> enumType;
        private Optional<T[]> universe = Optional.empty();
        private boolean alterable = false;

        private Builder(Class<T> clazz) {
            this.enumType = clazz;
        }

        public Builder<T> setUniverse(T ... universe) {
            this.universe = Optional.of(universe);
            return this;
        }

        public Builder<T> setAlterable() {
            this.alterable = true;
            return this;
        }

        @Override
        public EnumKeyType<T> create() {
            EnumKeyType handler = new EnumKeyType(this.enumType, this.universe.orElse(null), this.alterable);
            return handler;
        }
    }
}

