/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.solve;

import com.alexbarter.ciphertool.base.interfaces.IAttackMethod;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.lib.result.Result;
import com.alexbarter.ciphertool.lib.result.Solution;
import java.util.Arrays;

public interface IKeySearchAttack<K>
extends IAttackMethod<K> {
    default public IDecryptionTracker tryKeySearch(IDecryptionTracker tracker, int length) {
        boolean change;
        tracker.getProgress().setIndeterminate(true);
        char[] parent = new char[length];
        Arrays.fill(parent, 'A');
        Solution currentBestSolution = Solution.WORST_SOLUTION;
        do {
            change = false;
            for (int i = 0; i < length; ++i) {
                char j = 'A';
                while (j <= 'Z') {
                    if (tracker.shouldStop()) {
                        return tracker;
                    }
                    char previous = parent[i];
                    parent[i] = j;
                    tracker.setLastSolution(this.toSolution(tracker, this.useStringGetKey(tracker, new String(parent))));
                    tracker.addSolution(tracker.getLastSolution());
                    if (tracker.getLastSolution().compareTo((Result)currentBestSolution) < 0) {
                        currentBestSolution = tracker.getLastSolution();
                        currentBestSolution.bake();
                        change = previous != j;
                    } else {
                        parent[i] = previous;
                    }
                    tracker.getProgress().increment();
                    j = (char)(j + this.getCharStep());
                }
            }
        } while (change);
        this.updateIfBetterThanBest(tracker, currentBestSolution, () -> this.useStringGetKey(tracker, new String(parent)));
        tracker.getProgress().finish();
        return tracker;
    }

    public K useStringGetKey(IDecryptionTracker var1, String var2);

    default public boolean hasDuplicateLetters() {
        return true;
    }

    default public int getCharStep() {
        return 1;
    }
}

