/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.key.types;

import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.KeyGeneration;
import com.alexbarter.ciphertool.base.key.KeyIterator;
import com.alexbarter.ciphertool.lib.characters.CharSequenceUtils;
import com.alexbarter.ciphertool.lib.characters.CharacterArrayUtils;
import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;

public class PolluxKeyType
implements IKeyType<Character[]> {
    private final CharSequence alphabet;

    private PolluxKeyType(CharSequence alphabet) {
        this.alphabet = alphabet;
    }

    @Override
    public Character[] randomise() {
        return KeyGeneration.createKeyGuaranteed(this.alphabet, 10);
    }

    @Override
    public boolean isValid(Character[] key) {
        int i;
        for (i = 0; i < this.alphabet.length(); ++i) {
            if (ArrayUtil.contains((Object[])key, (Object)Character.valueOf(this.alphabet.charAt(i)))) continue;
            return false;
        }
        for (i = 0; i < key.length; ++i) {
            if (CharSequenceUtils.contains((CharSequence)this.alphabet, (char)key[i].charValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean iterateKeys(Function<Character[], Boolean> consumer) {
        return KeyIterator.iterateObject(consumer, 10, CharSequenceUtils.toArray((CharSequence)this.alphabet));
    }

    @Override
    public Character[] alterKey(Character[] key) {
        int pos = RandomUtil.pickRandomInt((int)key.length);
        key[pos] = Character.valueOf(RandomUtil.pickRandomChar((CharSequence)this.alphabet));
        return key;
    }

    @Override
    public String prettifyKey(Character[] key) {
        return CharacterArrayUtils.toString((Character[])key);
    }

    @Override
    public BigInteger getNumOfKeys() {
        return BigInteger.valueOf(59049L);
    }

    @Override
    public Character[] parse(String input) throws ParseException {
        if (input.length() != 10) {
            throw new ParseException(input, input.length());
        }
        input = input.toUpperCase(Locale.ROOT);
        Character[] key = new Character[10];
        for (int i = 0; i < 10; ++i) {
            key[i] = Character.valueOf(input.charAt(i));
            if (CharSequenceUtils.contains((CharSequence)this.alphabet, (char)key[i].charValue())) continue;
            throw new ParseException("Invalid character", i);
        }
        return key;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IKeyType.IKeyBuilder<Character[]> {
        private Optional<CharSequence> alphabet = Optional.empty();

        private Builder() {
        }

        public Builder setAlphabet(CharSequence alphabet) {
            this.alphabet = Optional.of(alphabet);
            return this;
        }

        public PolluxKeyType create() {
            PolluxKeyType handler = new PolluxKeyType(this.alphabet.orElse("X.-"));
            return handler;
        }
    }
}

