/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.key.types;

import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Optional;
import java.util.function.Function;

public class ObjectKeyType<T>
implements IKeyType<T> {
    private final T[] universe;
    private final boolean alterable;

    private ObjectKeyType(T[] universe, boolean alterable) {
        this.universe = universe;
        this.alterable = alterable;
    }

    @Override
    public T randomise() {
        return (T)RandomUtil.pickRandomElement((Object[])this.universe);
    }

    @Override
    public boolean isValid(T key) {
        return ArrayUtil.contains((Object[])this.universe, key);
    }

    @Override
    public boolean iterateKeys(Function<T, Boolean> consumer) {
        for (T atom : this.universe) {
            if (consumer.apply(atom).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public BigInteger getNumOfKeys() {
        return BigInteger.valueOf(this.universe.length);
    }

    @Override
    public T alterKey(T key) {
        return (T)(this.alterable ? RandomUtil.pickRandomElement((Object[])this.universe) : key);
    }

    @Override
    public T parse(String input) throws ParseException {
        for (T atom : this.universe) {
            if (atom instanceof Character) {
                if (((Character)atom).charValue() != input.charAt(0)) continue;
                return atom;
            }
            if (atom instanceof String) {
                if (!((String)atom).equalsIgnoreCase(input)) continue;
                return atom;
            }
            if (!(atom instanceof Integer)) continue;
            try {
                if ((Integer)atom != Integer.parseInt(input)) continue;
                return atom;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ParseException(input, 0);
    }

    @Override
    public String getHelp() {
        StringBuilder builder = new StringBuilder();
        for (T atom : this.universe) {
            if (!(atom instanceof Character)) continue;
            builder.append(atom);
        }
        return builder.toString();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T>
    implements IKeyType.IKeyBuilder<T> {
        private Optional<T[]> universe = Optional.empty();
        private boolean alterable = false;

        private Builder() {
        }

        public Builder<T> setUniverse(T ... universe) {
            this.universe = Optional.of(universe);
            return this;
        }

        public Builder<T> setAlterable() {
            this.alterable = true;
            return this;
        }

        @Override
        public ObjectKeyType<T> create() {
            ObjectKeyType<Object> handler = new ObjectKeyType<Object>(this.universe.orElse(null), this.alterable);
            return handler;
        }
    }
}

