/*
 * Decompiled with CFR 0.152.
 */
package tools.android.networkinterfacewatcher;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import tools.android.networkinterfacewatcher.ConnectionType;
import tools.android.networkinterfacewatcher.NetworkInterfaceWatcher;
import tools.android.networkinterfacewatcher.NetworkState;
import tools.android.networkinterfacewatcher.NetworkType;
import tools.android.networkinterfacewatcher.NetworkUtil;

public class NetworkWatcher {
    protected NetworkInterfaceWatcher connectivityWatcher;
    protected NetworkState state;
    protected ConnectionType type;
    private Object lock = new Object();

    public NetworkWatcher(Context context) {
        this(context, false);
    }

    public NetworkWatcher(Context context, boolean enableLogcat) {
        this(context, enableLogcat, 0L);
    }

    public NetworkWatcher(Context context, long debounceMillis) {
        this(context, false, debounceMillis);
    }

    public NetworkWatcher(Context context, boolean enableLogcat, long debounceMillis) {
        this.connectivityWatcher = new NetworkInterfaceWatcher(enableLogcat, debounceMillis){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void networkUnavailable() {
                super.networkUnavailable();
                NetworkType oldType = NetworkWatcher.this.getNetType();
                NetworkWatcher.this.state = NetworkState.unavailable;
                NetworkWatcher.this.type = null;
                NetworkType newType = NetworkWatcher.this.getNetType();
                Object object = NetworkWatcher.this.lock;
                synchronized (object) {
                    NetworkWatcher.this.onUnavailable();
                    if (oldType != newType) {
                        NetworkWatcher.this.onChange(oldType, newType);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void nonWifiState() {
                super.nonWifiState();
                NetworkType oldType = NetworkWatcher.this.getNetType();
                NetworkWatcher.this.state = NetworkState.available;
                NetworkWatcher.this.type = ConnectionType.MOBILE;
                NetworkType newType = NetworkWatcher.this.getNetType();
                Object object = NetworkWatcher.this.lock;
                synchronized (object) {
                    NetworkWatcher.this.onAvailable(ConnectionType.MOBILE);
                    if (oldType != newType) {
                        NetworkWatcher.this.onChange(oldType, newType);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void wifiState() {
                super.wifiState();
                NetworkType oldType = NetworkWatcher.this.getNetType();
                NetworkWatcher.this.state = NetworkState.available;
                NetworkWatcher.this.type = ConnectionType.WIFI;
                NetworkType newType = NetworkWatcher.this.getNetType();
                Object object = NetworkWatcher.this.lock;
                synchronized (object) {
                    NetworkWatcher.this.onAvailable(ConnectionType.WIFI);
                    if (oldType != newType) {
                        NetworkWatcher.this.onChange(oldType, newType);
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        try {
            context.registerReceiver((BroadcastReceiver)this.connectivityWatcher, filter);
            this.connectivityWatcher.say("NetworkWatcher", "regist");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.state = NetworkState.unavailable;
        this.type = null;
        if (NetworkUtil.checkNetworkState(context)) {
            this.state = NetworkState.available;
            this.type = !NetworkUtil.checkWifiState(context) ? ConnectionType.MOBILE : ConnectionType.WIFI;
        }
    }

    public NetworkState getState() {
        return this.state;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public NetworkType getNetType() {
        if (NetworkState.unavailable == this.getState()) {
            return NetworkType.Disconnect;
        }
        if (NetworkState.available == this.getState()) {
            if (ConnectionType.MOBILE == this.getType()) {
                return NetworkType.Mobile;
            }
            if (ConnectionType.WIFI == this.getType()) {
                return NetworkType.Wifi;
            }
        }
        return NetworkType.Unknown;
    }

    public void release(Context context) {
        if (this.connectivityWatcher != null) {
            try {
                context.unregisterReceiver((BroadcastReceiver)this.connectivityWatcher);
                this.connectivityWatcher.say("NetworkWatcher", "unregist");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connectivityWatcher = null;
    }

    protected void onUnavailable() {
    }

    protected void onAvailable(ConnectionType type) {
    }

    protected void onChange(NetworkType oldType, NetworkType newType) {
    }
}

