/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.logging;

import java.io.Writer;
import javax.servlet.ServletContext;
import org.apache.jasper.logging.LogDaemon;
import org.apache.jasper.logging.Logger;
import org.apache.jasper.util.Queue;

public class JasperLogger
extends Logger {
    static LogDaemon logDaemon = null;
    static Queue logQueue = null;
    ServletContext servletContext = null;

    public JasperLogger() {
        this.init();
    }

    public JasperLogger(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.init();
    }

    public void flush() {
        logDaemon.flush();
    }

    private void init() {
        if (logDaemon == null || logQueue == null) {
            logQueue = new Queue();
            LogDaemon logDaemon = new LogDaemon(logQueue, this.servletContext);
            logDaemon.start();
        }
    }

    protected void realLog(String message) {
        logQueue.put(new LogEntry(message, null));
    }

    protected void realLog(String message, Throwable t) {
        logQueue.put(new LogEntry(message, t));
    }

    public String toString() {
        return "JasperLogger(" + this.getName() + ", " + this.getPath() + ")";
    }

    class LogEntry {
        String logName;
        long date;
        String message;
        Throwable t;

        LogEntry(String message, Throwable t) {
            if (JasperLogger.this.timestamp) {
                this.date = System.currentTimeMillis();
            }
            this.message = message;
            this.t = t;
        }

        Writer getWriter() {
            return JasperLogger.this.sink;
        }

        public String toString() {
            StringBuffer val = new StringBuffer();
            if (!JasperLogger.this.custom) {
                val.append("<");
                val.append(JasperLogger.this.getName());
                val.append("> ");
            }
            if (JasperLogger.this.timestamp) {
                JasperLogger.this.formatTimestamp(this.date, val);
                val.append(" - ");
            }
            if (this.message != null) {
                val.append(this.message);
            }
            if (this.t != null) {
                val.append(" - ");
                val.append(Logger.throwableToString(this.t));
            }
            if (!JasperLogger.this.custom) {
                val.append("</");
                val.append(JasperLogger.this.getName());
                val.append("> ");
            }
            return val.toString();
        }
    }
}

