/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.provider;

import java.lang.reflect.Field;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;
import tk.mybatis.mapper.mapperhelper.SelectKeyHelper;
import tk.mybatis.mapper.mapperhelper.SqlHelper;

public class SaveProvider
extends MapperTemplate {
    public SaveProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public String save(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        Field[] fields = entityClass.getFields();
        StringBuilder sql = new StringBuilder();
        Set<EntityColumn> columnList = EntityHelper.getPKColumns(entityClass);
        if (columnList.size() == 1) {
            EntityColumn column = columnList.iterator().next();
            String id = column.getColumn();
            sql.append("<choose>");
            sql.append("<when test='" + id + "!=null'>");
            sql.append(this.updateByPrimaryKey(ms));
            sql.append("</when>");
            sql.append("<otherwise>");
            sql.append(this.insert(ms));
            sql.append("</otherwise>");
            sql.append("</choose>");
            return sql.toString();
        }
        return this.insert(ms);
    }

    public String updateByPrimaryKey(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.updateTable(entityClass, this.tableName(entityClass)));
        sql.append(SqlHelper.updateSetColumns(entityClass, null, false, false));
        sql.append(SqlHelper.wherePKColumns(entityClass, true));
        return sql.toString();
    }

    public String insert(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        this.processKey(sql, entityClass, ms, columnList);
        sql.append(SqlHelper.insertIntoTable(entityClass, this.tableName(entityClass)));
        sql.append(SqlHelper.insertColumns(entityClass, false, false, false));
        sql.append("<trim prefix=\"VALUES(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (column.isIdentity()) {
                sql.append(SqlHelper.getIfCacheNotNull(column, column.getColumnHolder(null, "_cache", ",")));
            } else {
                sql.append(SqlHelper.getIfNotNull(column, column.getColumnHolder(null, null, ","), this.isNotEmpty()));
            }
            if (column.isIdentity()) {
                sql.append(SqlHelper.getIfCacheIsNull(column, column.getColumnHolder() + ","));
                continue;
            }
            sql.append(SqlHelper.getIfIsNull(column, column.getColumnHolder(null, null, ","), this.isNotEmpty()));
        }
        sql.append("</trim>");
        return sql.toString();
    }

    private void processKey(StringBuilder sql, Class<?> entityClass, MappedStatement ms, Set<EntityColumn> columnList) {
        Boolean hasIdentityKey = false;
        for (EntityColumn column : columnList) {
            if (column.isIdentity()) {
                sql.append(SqlHelper.getBindCache(column));
                if (hasIdentityKey.booleanValue()) {
                    if (column.getGenerator() != null && column.getGenerator().equals("JDBC")) continue;
                    throw new MapperException(ms.getId() + "\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b" + entityClass.getName() + "\u4e2d\u5305\u542b\u591a\u4e2aMySql\u7684\u81ea\u52a8\u589e\u957f\u5217,\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a!");
                }
                SelectKeyHelper.newSelectKeyMappedStatement(ms, column, entityClass, this.isBEFORE(), this.getIDENTITY(column));
                hasIdentityKey = true;
                continue;
            }
            if (column.getGenIdClass() == null) continue;
            sql.append("<bind name=\"").append(column.getColumn()).append("GenIdBind\" value=\"@tk.mybatis.mapper.genid.GenIdUtil@genId(");
            sql.append("_parameter").append(", '").append(column.getProperty()).append("'");
            sql.append(", @").append(column.getGenIdClass().getName()).append("@class");
            sql.append(", '").append(this.tableName(entityClass)).append("'");
            sql.append(", '").append(column.getColumn()).append("')");
            sql.append("\"/>");
        }
    }
}

