/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.generator;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.CommentGeneratorConfiguration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.mybatis.generator.internal.util.StringUtility;
import tk.mybatis.mapper.generator.FalseMethodPlugin;
import tk.mybatis.mapper.generator.MapperCommentGenerator;

public class MapperPlugin
extends FalseMethodPlugin {
    private Set<String> mappers = new HashSet<String>();
    private boolean caseSensitive = false;
    private boolean useMapperCommentGenerator = true;
    private String beginningDelimiter = "";
    private String endingDelimiter = "";
    private String schema;
    private CommentGeneratorConfiguration commentCfg;
    private boolean forceAnnotation;
    private boolean needsData = false;
    private boolean needsGetter = false;
    private boolean needsSetter = false;
    private boolean needsToString = false;
    private boolean needsAccessors = false;
    private boolean needsBuilder = false;
    private boolean needsSuperBuilder = false;
    private boolean needsNoArgsConstructor = false;
    private boolean needsAllArgsConstructor = false;
    private boolean needsEqualsAndHashCode = false;
    private boolean needsEqualsAndHashCodeAndCallSuper = false;
    private boolean generateColumnConsts = false;
    private boolean generateDefaultInstanceMethod = false;
    private boolean needsSwagger = false;
    private boolean logicDelete = false;

    public String getDelimiterName(String name) {
        StringBuilder nameBuilder = new StringBuilder();
        if (StringUtility.stringHasValue((String)this.schema)) {
            nameBuilder.append(this.schema);
            nameBuilder.append(".");
        }
        nameBuilder.append(this.beginningDelimiter);
        nameBuilder.append(name);
        nameBuilder.append(this.endingDelimiter);
        return nameBuilder.toString();
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType entityType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        for (String mapper : this.mappers) {
            interfaze.addImportedType(new FullyQualifiedJavaType(mapper));
            interfaze.addSuperInterface(new FullyQualifiedJavaType(mapper + "<" + entityType.getShortName() + ">"));
        }
        interfaze.addImportedType(entityType);
        return true;
    }

    private void processEntityClass(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        topLevelClass.addImportedType("javax.persistence.*");
        if (this.needsData) {
            topLevelClass.addImportedType("lombok.Data");
            topLevelClass.addAnnotation("@Data");
        }
        if (this.needsGetter) {
            topLevelClass.addImportedType("lombok.Getter");
            topLevelClass.addAnnotation("@Getter");
        }
        if (this.needsSetter) {
            topLevelClass.addImportedType("lombok.Setter");
            topLevelClass.addAnnotation("@Setter");
        }
        if (this.needsToString) {
            topLevelClass.addImportedType("lombok.ToString");
            topLevelClass.addAnnotation("@ToString");
        }
        if (this.needsEqualsAndHashCodeAndCallSuper) {
            topLevelClass.addImportedType("lombok.EqualsAndHashCode");
            topLevelClass.addAnnotation("@EqualsAndHashCode(callSuper = true)");
        } else if (this.needsEqualsAndHashCode) {
            topLevelClass.addImportedType("lombok.EqualsAndHashCode");
            topLevelClass.addAnnotation("@EqualsAndHashCode");
        }
        if (this.needsAccessors) {
            topLevelClass.addImportedType("lombok.experimental.Accessors");
            topLevelClass.addAnnotation("@Accessors(chain = true)");
        }
        if (this.needsSuperBuilder) {
            topLevelClass.addImportedType("lombok.experimental.SuperBuilder");
            topLevelClass.addAnnotation("@SuperBuilder");
        }
        if (this.needsBuilder) {
            topLevelClass.addImportedType("lombok.Builder");
            topLevelClass.addAnnotation("@Builder");
        }
        if (this.needsNoArgsConstructor) {
            topLevelClass.addImportedType("lombok.NoArgsConstructor");
            topLevelClass.addAnnotation("@NoArgsConstructor");
        }
        if (this.needsAllArgsConstructor) {
            topLevelClass.addImportedType("lombok.AllArgsConstructor");
            topLevelClass.addAnnotation("@AllArgsConstructor");
        }
        if (this.needsSwagger) {
            topLevelClass.addImportedType("io.swagger.annotations.ApiModel");
            topLevelClass.addImportedType("io.swagger.annotations.ApiModelProperty");
            String remarks = introspectedTable.getRemarks();
            if (remarks == null) {
                remarks = "";
            }
            topLevelClass.addAnnotation("@ApiModel(\"" + remarks.replaceAll("\r", "").replaceAll("\n", "") + "\")");
        }
        String tableName = introspectedTable.getFullyQualifiedTableNameAtRuntime();
        String remarks = introspectedTable.getRemarks();
        topLevelClass.addJavaDocLine("/**");
        topLevelClass.addJavaDocLine(" * \u8868\u540d\uff1a" + tableName);
        if (remarks != null) {
            remarks = remarks.trim();
        }
        if (remarks != null && remarks.trim().length() > 0) {
            String[] lines = remarks.split("\\r?\\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i == 0) {
                    topLevelClass.addJavaDocLine(" * \u8868\u6ce8\u91ca\uff1a" + line);
                    continue;
                }
                topLevelClass.addJavaDocLine(" *         " + line);
            }
        }
        topLevelClass.addJavaDocLine("*/");
        if (StringUtility.stringContainsSpace((String)tableName)) {
            tableName = this.context.getBeginningDelimiter() + tableName + this.context.getEndingDelimiter();
        }
        if (this.caseSensitive && !topLevelClass.getType().getShortName().equals(tableName)) {
            topLevelClass.addAnnotation("@Table(name = \"" + this.getDelimiterName(tableName) + "\")");
        } else if (!topLevelClass.getType().getShortName().equalsIgnoreCase(tableName)) {
            topLevelClass.addAnnotation("@Table(name = \"" + this.getDelimiterName(tableName) + "\")");
        } else if (StringUtility.stringHasValue((String)this.schema) || StringUtility.stringHasValue((String)this.beginningDelimiter) || StringUtility.stringHasValue((String)this.endingDelimiter)) {
            topLevelClass.addAnnotation("@Table(name = \"" + this.getDelimiterName(tableName) + "\")");
        } else if (this.forceAnnotation) {
            topLevelClass.addAnnotation("@Table(name = \"" + this.getDelimiterName(tableName) + "\")");
        }
        if (this.generateColumnConsts) {
            for (IntrospectedColumn introspectedColumn : introspectedTable.getAllColumns()) {
                String fieldName = introspectedColumn.getActualColumnName().toUpperCase();
                FullyQualifiedJavaType fieldType = new FullyQualifiedJavaType(String.class.getName());
                org.mybatis.generator.api.dom.java.Field field = new org.mybatis.generator.api.dom.java.Field(fieldName, fieldType);
                field.setVisibility(JavaVisibility.PUBLIC);
                field.setStatic(true);
                field.setFinal(true);
                field.setInitializationString("\"" + introspectedColumn.getJavaProperty() + "\"");
                this.context.getCommentGenerator().addFieldComment(field, introspectedTable, introspectedColumn);
                topLevelClass.addField(field);
                String columnFieldName = "DB_" + introspectedColumn.getActualColumnName().toUpperCase();
                FullyQualifiedJavaType columnFieldType = new FullyQualifiedJavaType(String.class.getName());
                org.mybatis.generator.api.dom.java.Field columnField = new org.mybatis.generator.api.dom.java.Field(columnFieldName, columnFieldType);
                columnField.setVisibility(JavaVisibility.PUBLIC);
                columnField.setStatic(true);
                columnField.setFinal(true);
                columnField.setInitializationString("\"" + introspectedColumn.getActualColumnName() + "\"");
                topLevelClass.addField(columnField);
            }
        }
        if (this.logicDelete) {
            topLevelClass.addImportedType("tk.mybatis.mapper.annotation.LogicDelete");
        }
        if (this.generateDefaultInstanceMethod) {
            List<String> baseClassName = Arrays.asList("byte", "short", "char", "int", "long", "float", "double", "boolean");
            List<String> wrapperClassName = Arrays.asList("Byte", "Short", "Character", "Integer", "Long", "Float", "Double", "Boolean");
            List<String> otherClassName = Arrays.asList("String", "BigDecimal", "BigInteger");
            Method defaultMethod = new Method("defaultInstance");
            defaultMethod.addJavaDocLine("/**");
            defaultMethod.addJavaDocLine(" * \u5e26\u9ed8\u8ba4\u503c\u7684\u5b9e\u4f8b");
            defaultMethod.addJavaDocLine("*/");
            defaultMethod.setStatic(true);
            defaultMethod.setVisibility(JavaVisibility.PUBLIC);
            defaultMethod.setReturnType(topLevelClass.getType());
            defaultMethod.addBodyLine(String.format("%s instance = new %s();", topLevelClass.getType().getShortName(), topLevelClass.getType().getShortName()));
            for (IntrospectedColumn introspectedColumn : introspectedTable.getAllColumns()) {
                String shortName = introspectedColumn.getFullyQualifiedJavaType().getShortName();
                if (!baseClassName.contains(shortName) && !wrapperClassName.contains(shortName) && !otherClassName.contains(shortName) || introspectedColumn.getDefaultValue() == null) continue;
                String defaultValue = introspectedColumn.getDefaultValue();
                if (defaultValue.matches("'\\.*'::\\w+(\\s\\w+)?")) {
                    defaultValue = defaultValue.substring(0, defaultValue.lastIndexOf("::"));
                }
                if (defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                    defaultValue = defaultValue.length() == 2 ? "" : defaultValue.substring(1, defaultValue.length() - 1);
                }
                if ("Boolean".equals(shortName) || "boolean".equals(shortName)) {
                    if ("0".equals(defaultValue)) {
                        defaultValue = "false";
                    } else if ("1".equals(defaultValue)) {
                        defaultValue = "true";
                    }
                }
                if ("String".equals(shortName)) {
                    defaultMethod.addBodyLine(String.format("instance.%s = \"%s\";", introspectedColumn.getJavaProperty(), defaultValue));
                    continue;
                }
                String javaProperty = introspectedColumn.getJavaProperty();
                if (baseClassName.contains(shortName)) {
                    javaProperty = wrapperClassName.get(baseClassName.indexOf(shortName));
                }
                defaultMethod.addBodyLine(String.format("instance.%s = new %s(\"%s\");", javaProperty, shortName, defaultValue));
            }
            defaultMethod.addBodyLine("return instance;");
            topLevelClass.addMethod(defaultMethod);
        }
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return !this.needsData && !this.needsGetter;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return !this.needsData && !this.needsSetter;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.processEntityClass(topLevelClass, introspectedTable);
        return true;
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.processEntityClass(topLevelClass, introspectedTable);
        return true;
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.processEntityClass(topLevelClass, introspectedTable);
        return false;
    }

    public void setContext(Context context) {
        super.setContext(context);
        boolean bl = this.useMapperCommentGenerator = !"FALSE".equalsIgnoreCase(context.getProperty("useMapperCommentGenerator"));
        if (this.useMapperCommentGenerator) {
            this.commentCfg = new CommentGeneratorConfiguration();
            this.commentCfg.setConfigurationType(MapperCommentGenerator.class.getName());
            context.setCommentGeneratorConfiguration(this.commentCfg);
        }
        JDBCConnectionConfiguration jdbcConnectionConfiguration = null;
        try {
            Field jdbcConnectionConfigurationField = Context.class.getDeclaredField("jdbcConnectionConfiguration");
            jdbcConnectionConfigurationField.setAccessible(true);
            jdbcConnectionConfiguration = (JDBCConnectionConfiguration)jdbcConnectionConfigurationField.get(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        jdbcConnectionConfiguration.addProperty("remarksReporting", "true");
        jdbcConnectionConfiguration.addProperty("useInformationSchema", "true");
    }

    public void setProperties(Properties properties) {
        String swagger;
        super.setProperties(properties);
        String mappers = this.getProperty("mappers");
        if (StringUtility.stringHasValue((String)mappers)) {
            for (String mapper : mappers.split(",")) {
                this.mappers.add(mapper);
            }
        } else {
            throw new RuntimeException("Mapper\u63d2\u4ef6\u7f3a\u5c11\u5fc5\u8981\u7684mappers\u5c5e\u6027!");
        }
        this.caseSensitive = Boolean.parseBoolean(this.properties.getProperty("caseSensitive"));
        this.forceAnnotation = this.getPropertyAsBoolean("forceAnnotation");
        this.beginningDelimiter = this.getProperty("beginningDelimiter", "");
        this.endingDelimiter = this.getProperty("endingDelimiter", "");
        this.schema = this.getProperty("schema");
        String lombok = this.getProperty("lombok");
        if (lombok != null && !"".equals(lombok)) {
            this.needsData = lombok.contains("Data");
            this.needsGetter = !this.needsData && lombok.contains("Getter");
            this.needsSetter = !this.needsData && lombok.contains("Setter");
            this.needsToString = !this.needsData && lombok.contains("ToString");
            this.needsEqualsAndHashCode = !this.needsData && lombok.contains("EqualsAndHashCode");
            String lombokEqualsAndHashCodeCallSuper = this.getProperty("lombokEqualsAndHashCodeCallSuper", "false");
            this.needsEqualsAndHashCodeAndCallSuper = this.needsEqualsAndHashCode && "TRUE".equalsIgnoreCase(lombokEqualsAndHashCodeCallSuper);
            this.needsAccessors = lombok.contains("Accessors");
            this.needsSuperBuilder = lombok.contains("SuperBuilder");
            this.needsBuilder = !this.needsSuperBuilder && lombok.contains("Builder");
            this.needsNoArgsConstructor = lombok.contains("NoArgsConstructor");
            this.needsAllArgsConstructor = lombok.contains("AllArgsConstructor");
        }
        if ("TRUE".equalsIgnoreCase(swagger = this.getProperty("swagger", "false"))) {
            this.needsSwagger = true;
        }
        if (this.useMapperCommentGenerator) {
            this.commentCfg.addProperty("beginningDelimiter", this.beginningDelimiter);
            this.commentCfg.addProperty("endingDelimiter", this.endingDelimiter);
            String forceAnnotation = this.getProperty("forceAnnotation");
            if (StringUtility.stringHasValue((String)forceAnnotation)) {
                this.commentCfg.addProperty("forceAnnotation", forceAnnotation);
            }
            this.commentCfg.addProperty("needsSwagger", this.needsSwagger + "");
        }
        this.generateColumnConsts = this.getPropertyAsBoolean("generateColumnConsts");
        this.generateDefaultInstanceMethod = this.getPropertyAsBoolean("generateDefaultInstanceMethod");
        this.logicDelete = Boolean.parseBoolean(this.properties.getProperty("logicDelete"));
    }

    protected String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    protected String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    protected Boolean getPropertyAsBoolean(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }
}

