/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.type.TypeHandler;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.entity.IDynamicTableName;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.util.StringUtil;

public class Example
implements IDynamicTableName {
    protected String orderByClause;
    protected boolean distinct;
    protected boolean exists;
    protected boolean notNull;
    protected boolean forUpdate;
    protected Set<String> selectColumns;
    protected Set<String> excludeColumns;
    protected String countColumn;
    protected List<Criteria> oredCriteria;
    protected Class<?> entityClass;
    protected EntityTable table;
    protected Map<String, EntityColumn> propertyMap;
    protected String tableName;
    protected OrderBy ORDERBY;

    public Example(Class<?> entityClass) {
        this(entityClass, true);
    }

    public Example(Class<?> entityClass, boolean exists) {
        this(entityClass, exists, false);
    }

    public Example(Class<?> entityClass, boolean exists, boolean notNull) {
        this.exists = exists;
        this.notNull = notNull;
        this.oredCriteria = new ArrayList<Criteria>();
        this.entityClass = entityClass;
        this.table = EntityHelper.getEntityTable(entityClass);
        this.propertyMap = this.table.getPropertyMap();
        this.ORDERBY = new OrderBy(this, this.propertyMap);
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public OrderBy orderBy(String property) {
        this.ORDERBY.orderBy(property);
        return this.ORDERBY;
    }

    public Set<String> getSelectColumns() {
        if ((this.selectColumns == null || this.selectColumns.size() <= 0) && this.excludeColumns != null && this.excludeColumns.size() > 0) {
            Collection<EntityColumn> entityColumns = this.propertyMap.values();
            this.selectColumns = new LinkedHashSet<String>(entityColumns.size() - this.excludeColumns.size());
            for (EntityColumn column : entityColumns) {
                if (this.excludeColumns.contains(column.getColumn())) continue;
                this.selectColumns.add(column.getColumn());
            }
        }
        return this.selectColumns;
    }

    public Example excludeProperties(String ... properties) {
        if (properties != null && properties.length > 0) {
            if (this.excludeColumns == null) {
                this.excludeColumns = new LinkedHashSet<String>();
            }
            for (String property : properties) {
                if (!this.propertyMap.containsKey(property)) continue;
                this.excludeColumns.add(this.propertyMap.get(property).getColumn());
            }
        }
        return this;
    }

    public Example selectProperties(String ... properties) {
        if (properties != null && properties.length > 0) {
            if (this.selectColumns == null) {
                this.selectColumns = new LinkedHashSet<String>();
            }
            for (String property : properties) {
                if (!this.propertyMap.containsKey(property)) continue;
                this.selectColumns.add(this.propertyMap.get(property).getColumn());
            }
        }
        return this;
    }

    public String getCountColumn() {
        return this.countColumn;
    }

    public void setCountProperty(String property) {
        if (this.propertyMap.containsKey(property)) {
            this.countColumn = this.propertyMap.get(property).getColumn();
        }
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public List<Criteria> getOredCriteria() {
        return this.oredCriteria;
    }

    public void or(Criteria criteria) {
        criteria.setAndOr("or");
        this.oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = this.createCriteriaInternal();
        criteria.setAndOr("or");
        this.oredCriteria.add(criteria);
        return criteria;
    }

    public void and(Criteria criteria) {
        criteria.setAndOr("and");
        this.oredCriteria.add(criteria);
    }

    public Criteria and() {
        Criteria criteria = this.createCriteriaInternal();
        criteria.setAndOr("and");
        this.oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = this.createCriteriaInternal();
        if (this.oredCriteria.size() == 0) {
            criteria.setAndOr("and");
            this.oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.propertyMap, this.exists, this.notNull);
        return criteria;
    }

    public void clear() {
        this.oredCriteria.clear();
        this.orderByClause = null;
        this.distinct = false;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String getDynamicTableName() {
        return this.tableName;
    }

    public static class Criterion {
        private String condition;
        private Object value;
        private Object secondValue;
        private String andOr;
        private boolean noValue;
        private boolean singleValue;
        private boolean betweenValue;
        private boolean listValue;
        private String typeHandler;

        protected Criterion(String condition) {
            this(condition, false);
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            this(condition, value, typeHandler, false);
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null, false);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            this(condition, value, secondValue, typeHandler, false);
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null, false);
        }

        protected Criterion(String condition, boolean isOr) {
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
            this.andOr = isOr ? "or" : "and";
        }

        protected Criterion(String condition, Object value, String typeHandler, boolean isOr) {
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            String string = this.andOr = isOr ? "or" : "and";
            if (value instanceof Collection) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value, boolean isOr) {
            this(condition, value, null, isOr);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler, boolean isOr) {
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
            this.andOr = isOr ? "or" : "and";
        }

        protected Criterion(String condition, Object value, Object secondValue, boolean isOr) {
            this(condition, value, secondValue, null, isOr);
        }

        public String getCondition() {
            return this.condition;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getSecondValue() {
            return this.secondValue;
        }

        public String getAndOr() {
            return this.andOr;
        }

        public void setAndOr(String andOr) {
            this.andOr = andOr;
        }

        public boolean isNoValue() {
            return this.noValue;
        }

        public boolean isSingleValue() {
            return this.singleValue;
        }

        public boolean isBetweenValue() {
            return this.betweenValue;
        }

        public boolean isListValue() {
            return this.listValue;
        }

        public String getTypeHandler() {
            return this.typeHandler;
        }
    }

    public static class Criteria
    extends GeneratedCriteria {
        protected Criteria(Map<String, EntityColumn> propertyMap, boolean exists, boolean notNull) {
            super(propertyMap, exists, notNull);
        }
    }

    protected static abstract class GeneratedCriteria {
        protected List<Criterion> criteria;
        protected boolean exists;
        protected boolean notNull;
        protected String andOr;
        protected Map<String, EntityColumn> propertyMap;

        protected GeneratedCriteria(Map<String, EntityColumn> propertyMap, boolean exists, boolean notNull) {
            this.exists = exists;
            this.notNull = notNull;
            this.criteria = new ArrayList<Criterion>();
            this.propertyMap = propertyMap;
        }

        private String column(String property) {
            if (this.propertyMap.containsKey(property)) {
                return this.propertyMap.get(property).getColumn();
            }
            if (this.exists) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return null;
        }

        private String property(String property) {
            if (this.propertyMap.containsKey(property)) {
                return property;
            }
            if (this.exists) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return null;
        }

        public String getAndOr() {
            return this.andOr;
        }

        public void setAndOr(String andOr) {
            this.andOr = andOr;
        }

        public boolean isValid() {
            return this.criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return this.criteria;
        }

        public List<Criterion> getCriteria() {
            return this.criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new MapperException("Value for condition cannot be null");
            }
            if (condition.startsWith("null")) {
                return;
            }
            this.criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                if (this.notNull) {
                    throw new MapperException("Value for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                if (this.notNull) {
                    throw new MapperException("Between values for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addOrCriterion(String condition) {
            if (condition == null) {
                throw new MapperException("Value for condition cannot be null");
            }
            if (condition.startsWith("null")) {
                return;
            }
            this.criteria.add(new Criterion(condition, true));
        }

        protected void addOrCriterion(String condition, Object value, String property) {
            if (value == null) {
                if (this.notNull) {
                    throw new MapperException("Value for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value, true));
        }

        protected void addOrCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                if (this.notNull) {
                    throw new MapperException("Between values for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value1, value2, true));
        }

        public Criteria andIsNull(String property) {
            this.addCriterion(this.column(property) + " is null");
            return (Criteria)this;
        }

        public Criteria andIsNotNull(String property) {
            this.addCriterion(this.column(property) + " is not null");
            return (Criteria)this;
        }

        public Criteria andEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " =", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andNotEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " <>", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andGreaterThan(String property, Object value) {
            this.addCriterion(this.column(property) + " >", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andGreaterThanOrEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " >=", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andLessThan(String property, Object value) {
            this.addCriterion(this.column(property) + " <", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andLessThanOrEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " <=", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andIn(String property, Iterable values) {
            this.addCriterion(this.column(property) + " in", values, this.property(property));
            return (Criteria)this;
        }

        public Criteria andNotIn(String property, Iterable values) {
            this.addCriterion(this.column(property) + " not in", values, this.property(property));
            return (Criteria)this;
        }

        public Criteria andBetween(String property, Object value1, Object value2) {
            this.addCriterion(this.column(property) + " between", value1, value2, this.property(property));
            return (Criteria)this;
        }

        public Criteria andNotBetween(String property, Object value1, Object value2) {
            this.addCriterion(this.column(property) + " not between", value1, value2, this.property(property));
            return (Criteria)this;
        }

        public Criteria andLike(String property, String value) {
            this.addCriterion(this.column(property) + "  like", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andNotLike(String property, String value) {
            this.addCriterion(this.column(property) + "  not like", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andCondition(String condition) {
            this.addCriterion(condition);
            return (Criteria)this;
        }

        public Criteria andCondition(String condition, Object value) {
            this.criteria.add(new Criterion(condition, value));
            return (Criteria)this;
        }

        @Deprecated
        public Criteria andCondition(String condition, Object value, String typeHandler) {
            this.criteria.add(new Criterion(condition, value, typeHandler));
            return (Criteria)this;
        }

        @Deprecated
        public Criteria andCondition(String condition, Object value, Class<? extends TypeHandler> typeHandler) {
            this.criteria.add(new Criterion(condition, value, typeHandler.getCanonicalName()));
            return (Criteria)this;
        }

        public Criteria andEqualTo(Object param) {
            String[] properties;
            MetaObject metaObject = SystemMetaObject.forObject((Object)param);
            for (String property : properties = metaObject.getGetterNames()) {
                Object value;
                if (this.propertyMap.get(property) == null || (value = metaObject.getValue(property)) == null) continue;
                this.andEqualTo(property, value);
            }
            return (Criteria)this;
        }

        public Criteria andAllEqualTo(Object param) {
            String[] properties;
            MetaObject metaObject = SystemMetaObject.forObject((Object)param);
            for (String property : properties = metaObject.getGetterNames()) {
                if (this.propertyMap.get(property) == null) continue;
                Object value = metaObject.getValue(property);
                if (value != null) {
                    this.andEqualTo(property, value);
                    continue;
                }
                this.andIsNull(property);
            }
            return (Criteria)this;
        }

        public Criteria orIsNull(String property) {
            this.addOrCriterion(this.column(property) + " is null");
            return (Criteria)this;
        }

        public Criteria orIsNotNull(String property) {
            this.addOrCriterion(this.column(property) + " is not null");
            return (Criteria)this;
        }

        public Criteria orEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " =", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orNotEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " <>", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orGreaterThan(String property, Object value) {
            this.addOrCriterion(this.column(property) + " >", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orGreaterThanOrEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " >=", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orLessThan(String property, Object value) {
            this.addOrCriterion(this.column(property) + " <", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orLessThanOrEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " <=", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orIn(String property, Iterable values) {
            this.addOrCriterion(this.column(property) + " in", values, this.property(property));
            return (Criteria)this;
        }

        public Criteria orNotIn(String property, Iterable values) {
            this.addOrCriterion(this.column(property) + " not in", values, this.property(property));
            return (Criteria)this;
        }

        public Criteria orBetween(String property, Object value1, Object value2) {
            this.addOrCriterion(this.column(property) + " between", value1, value2, this.property(property));
            return (Criteria)this;
        }

        public Criteria orNotBetween(String property, Object value1, Object value2) {
            this.addOrCriterion(this.column(property) + " not between", value1, value2, this.property(property));
            return (Criteria)this;
        }

        public Criteria orLike(String property, String value) {
            this.addOrCriterion(this.column(property) + "  like", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orNotLike(String property, String value) {
            this.addOrCriterion(this.column(property) + "  not like", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orCondition(String condition) {
            this.addOrCriterion(condition);
            return (Criteria)this;
        }

        public Criteria orCondition(String condition, Object value) {
            this.criteria.add(new Criterion(condition, value, true));
            return (Criteria)this;
        }

        public Criteria orEqualTo(Object param) {
            String[] properties;
            MetaObject metaObject = SystemMetaObject.forObject((Object)param);
            for (String property : properties = metaObject.getGetterNames()) {
                Object value;
                if (this.propertyMap.get(property) == null || (value = metaObject.getValue(property)) == null) continue;
                this.orEqualTo(property, value);
            }
            return (Criteria)this;
        }

        public Criteria orAllEqualTo(Object param) {
            String[] properties;
            MetaObject metaObject = SystemMetaObject.forObject((Object)param);
            for (String property : properties = metaObject.getGetterNames()) {
                if (this.propertyMap.get(property) == null) continue;
                Object value = metaObject.getValue(property);
                if (value != null) {
                    this.orEqualTo(property, value);
                    continue;
                }
                this.orIsNull(property);
            }
            return (Criteria)this;
        }
    }

    public static class OrderBy {
        private Example example;
        private Boolean isProperty;
        protected Map<String, EntityColumn> propertyMap;
        protected boolean notNull;

        public OrderBy(Example example, Map<String, EntityColumn> propertyMap) {
            this.example = example;
            this.propertyMap = propertyMap;
        }

        private String property(String property) {
            if (this.propertyMap.containsKey(property)) {
                return this.propertyMap.get(property).getColumn();
            }
            if (this.notNull) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return null;
        }

        public OrderBy orderBy(String property) {
            String column = this.property(property);
            if (column == null) {
                this.isProperty = false;
                return this;
            }
            if (StringUtil.isNotEmpty(this.example.getOrderByClause())) {
                this.example.setOrderByClause(this.example.getOrderByClause() + "," + column);
            } else {
                this.example.setOrderByClause(column);
            }
            this.isProperty = true;
            return this;
        }

        public OrderBy desc() {
            if (this.isProperty.booleanValue()) {
                this.example.setOrderByClause(this.example.getOrderByClause() + " DESC");
                this.isProperty = false;
            }
            return this;
        }

        public OrderBy asc() {
            if (this.isProperty.booleanValue()) {
                this.example.setOrderByClause(this.example.getOrderByClause() + " ASC");
                this.isProperty = false;
            }
            return this;
        }
    }
}

