/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.spring.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import tk.mybatis.spring.annotation.MapperScan;
import tk.mybatis.spring.annotation.MapperScans;
import tk.mybatis.spring.mapper.MapperFactoryBean;
import tk.mybatis.spring.mapper.MapperScannerConfigurer;

public class MapperScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    public static final Logger LOGGER = LoggerFactory.getLogger(MapperScannerRegistrar.class);
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes mapperScanAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MapperScan.class.getName()));
        if (mapperScanAttrs != null) {
            this.registerBeanDefinitions(importingClassMetadata, mapperScanAttrs, registry, MapperScannerRegistrar.generateBaseBeanName(importingClassMetadata, 0));
        }
    }

    void registerBeanDefinitions(AnnotationMetadata annoMeta, AnnotationAttributes annoAttrs, BeanDefinitionRegistry registry, String beanName) {
        String defaultScope;
        AnnotationAttributes[] excludeFilterArray;
        String sqlSessionFactoryRef;
        String sqlSessionTemplateRef;
        Class mapperFactoryBeanClass;
        Class generatorClass;
        Class markerInterface;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MapperScannerConfigurer.class);
        builder.addPropertyValue("processPropertyPlaceHolders", (Object)annoAttrs.getBoolean("processPropertyPlaceHolders"));
        Class annotationClass = annoAttrs.getClass("annotationClass");
        if (!Annotation.class.equals((Object)annotationClass)) {
            builder.addPropertyValue("annotationClass", (Object)annotationClass);
        }
        if (!Class.class.equals((Object)(markerInterface = annoAttrs.getClass("markerInterface")))) {
            builder.addPropertyValue("markerInterface", (Object)markerInterface);
        }
        if (!BeanNameGenerator.class.equals((Object)(generatorClass = annoAttrs.getClass("nameGenerator")))) {
            builder.addPropertyValue("nameGenerator", BeanUtils.instantiateClass((Class)generatorClass));
        }
        if (!MapperFactoryBean.class.equals((Object)(mapperFactoryBeanClass = annoAttrs.getClass("factoryBean")))) {
            builder.addPropertyValue("mapperFactoryBeanClass", (Object)mapperFactoryBeanClass);
        }
        if (StringUtils.hasText((String)(sqlSessionTemplateRef = annoAttrs.getString("sqlSessionTemplateRef")))) {
            builder.addPropertyValue("sqlSessionTemplateBeanName", (Object)annoAttrs.getString("sqlSessionTemplateRef"));
        }
        if (StringUtils.hasText((String)(sqlSessionFactoryRef = annoAttrs.getString("sqlSessionFactoryRef")))) {
            builder.addPropertyValue("sqlSessionFactoryBeanName", (Object)annoAttrs.getString("sqlSessionFactoryRef"));
        }
        ArrayList<String> basePackages = new ArrayList<String>(Arrays.stream(annoAttrs.getStringArray("basePackages")).filter(StringUtils::hasText).collect(Collectors.toList()));
        basePackages.addAll(Arrays.stream(annoAttrs.getClassArray("basePackageClasses")).map(ClassUtils::getPackageName).collect(Collectors.toList()));
        if (basePackages.isEmpty()) {
            basePackages.add(MapperScannerRegistrar.getDefaultBasePackage(annoMeta));
        }
        if ((excludeFilterArray = annoAttrs.getAnnotationArray("excludeFilters")).length > 0) {
            ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
            ArrayList<Map<String, String>> rawTypeFilters = new ArrayList<Map<String, String>>();
            for (AnnotationAttributes excludeFilters : excludeFilterArray) {
                if (excludeFilters.getStringArray("pattern").length > 0) {
                    rawTypeFilters.addAll(this.parseFiltersHasPatterns(excludeFilters));
                    continue;
                }
                typeFilters.addAll(this.typeFiltersFor(excludeFilters));
            }
            builder.addPropertyValue("excludeFilters", typeFilters);
            builder.addPropertyValue("rawExcludeFilters", rawTypeFilters);
        }
        String mapperHelperRef = annoAttrs.getString("mapperHelperRef");
        String[] properties = annoAttrs.getStringArray("properties");
        if (StringUtils.hasText((String)mapperHelperRef)) {
            builder.addPropertyValue("mapperHelperBeanName", (Object)mapperHelperRef);
        } else if (properties != null && properties.length > 0) {
            builder.addPropertyValue("mapperProperties", (Object)properties);
        } else {
            try {
                builder.addPropertyValue("mapperProperties", (Object)this.environment);
            }
            catch (Exception e) {
                LOGGER.warn("\u53ea\u6709 Spring Boot \u73af\u5883\u4e2d\u53ef\u4ee5\u901a\u8fc7 Environment(\u914d\u7f6e\u6587\u4ef6,\u73af\u5883\u53d8\u91cf,\u8fd0\u884c\u53c2\u6570\u7b49\u65b9\u5f0f) \u914d\u7f6e\u901a\u7528 Mapper\uff0c\u5176\u4ed6\u73af\u5883\u8bf7\u901a\u8fc7 @MapperScan \u6ce8\u89e3\u4e2d\u7684 mapperHelperRef \u6216 properties \u53c2\u6570\u8fdb\u884c\u914d\u7f6e!\u5982\u679c\u4f60\u4f7f\u7528 tk.mybatis.mapper.session.Configuration \u914d\u7f6e\u7684\u901a\u7528 Mapper\uff0c\u4f60\u53ef\u4ee5\u5ffd\u7565\u8be5\u9519\u8bef!", (Throwable)e);
            }
        }
        String lazyInitialization = annoAttrs.getString("lazyInitialization");
        if (StringUtils.hasText((String)lazyInitialization)) {
            builder.addPropertyValue("lazyInitialization", (Object)lazyInitialization);
        }
        if (!"".equals(defaultScope = annoAttrs.getString("defaultScope"))) {
            builder.addPropertyValue("defaultScope", (Object)defaultScope);
        }
        builder.addPropertyValue("basePackage", (Object)StringUtils.collectionToCommaDelimitedString(basePackages));
        builder.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
    }

    private List<Map<String, String>> parseFiltersHasPatterns(AnnotationAttributes filterAttributes) {
        String[] expressionArray;
        ArrayList<Map<String, String>> rawTypeFilters = new ArrayList<Map<String, String>>();
        FilterType filterType = (FilterType)filterAttributes.getEnum("type");
        block3: for (String expression : expressionArray = filterAttributes.getStringArray("pattern")) {
            switch (filterType) {
                case REGEX: 
                case ASPECTJ: {
                    HashMap<String, String> typeFilter = new HashMap<String, String>(16);
                    typeFilter.put("type", filterType.name().toLowerCase());
                    typeFilter.put("expression", expression);
                    rawTypeFilters.add(typeFilter);
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException("Cannot specify the 'pattern' attribute if use the " + filterType + " FilterType in exclude filter of @MapperScan");
                }
            }
        }
        return rawTypeFilters;
    }

    private List<TypeFilter> typeFiltersFor(AnnotationAttributes filterAttributes) {
        ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
        FilterType filterType = (FilterType)filterAttributes.getEnum("type");
        block5: for (Class filterClass : filterAttributes.getClassArray("value")) {
            switch (filterType) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, (Class)filterClass, (String)"Specified an unsupported type in 'ANNOTATION' exclude filter of @MapperScan");
                    Class annoClass = filterClass;
                    typeFilters.add((TypeFilter)new AnnotationTypeFilter(annoClass));
                    continue block5;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add((TypeFilter)new AssignableTypeFilter(filterClass));
                    continue block5;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, (Class)filterClass, (String)"An error occured when processing a @ComponentScan CUSTOM type filter: ");
                    typeFilters.add((TypeFilter)BeanUtils.instantiateClass((Class)filterClass, TypeFilter.class));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Cannot specify the 'value' or 'classes' attribute if use the " + filterType + " FilterType in exclude filter of @MapperScan");
                }
            }
        }
        return typeFilters;
    }

    private static String generateBaseBeanName(AnnotationMetadata importingClassMetadata, int index) {
        return importingClassMetadata.getClassName() + "#" + MapperScannerRegistrar.class.getSimpleName() + "#" + index;
    }

    private static String getDefaultBasePackage(AnnotationMetadata importingClassMetadata) {
        return ClassUtils.getPackageName((String)importingClassMetadata.getClassName());
    }

    static class RepeatingRegistrar
    extends MapperScannerRegistrar {
        RepeatingRegistrar() {
        }

        @Override
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            AnnotationAttributes mapperScansAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MapperScans.class.getName()));
            if (mapperScansAttrs != null) {
                AnnotationAttributes[] annotations = mapperScansAttrs.getAnnotationArray("value");
                for (int i = 0; i < annotations.length; ++i) {
                    this.registerBeanDefinitions(importingClassMetadata, annotations[i], registry, MapperScannerRegistrar.generateBaseBeanName(importingClassMetadata, i));
                }
            }
        }
    }
}

