/*
 * Decompiled with CFR 0.152.
 */
package tk.jamunx.ui.browser.extras;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.google.android.material.R;
import com.google.android.material.snackbar.Snackbar;
import tk.jamunx.ui.browser.R;

public class MySnackBar {
    private static MySnackBar mySnackBar = new MySnackBar();
    private int colorSnackBar = R.color.libraryColorSnackBar;
    private int colorSnackBarText = R.color.libraryColorSnackBarText;

    public static MySnackBar getInstance() {
        return mySnackBar;
    }

    public void showSnackBarForMessage(Activity activity, int message) {
        this.showSnackBarForMessage(activity, activity.getString(message));
    }

    public void showSnackBarForMessage(Activity activity, String message) {
        try {
            Snackbar snackbar = Snackbar.make((View)activity.findViewById(R.id.id_coordinator_layout), (CharSequence)message, (int)0);
            View sbView = snackbar.getView();
            sbView.setBackgroundColor(activity.getResources().getColor(this.colorSnackBar));
            TextView textView = (TextView)sbView.findViewById(R.id.snackbar_text);
            textView.setTextColor(activity.getResources().getColor(this.colorSnackBarText));
            snackbar.show();
        }
        catch (Exception ignored) {
            Toast.makeText((Context)activity, (CharSequence)message, (int)0).show();
        }
    }

    public void showSnackBarForMessage(Activity activity, int message, int buttonName, final View.OnClickListener interfaceClick) {
        try {
            Snackbar snackbar = Snackbar.make((View)activity.findViewById(R.id.id_coordinator_layout), (CharSequence)activity.getString(message), (int)0);
            View sbView = snackbar.getView();
            sbView.setBackgroundColor(activity.getResources().getColor(this.colorSnackBar));
            TextView textView = (TextView)sbView.findViewById(R.id.snackbar_text);
            textView.setTextColor(activity.getResources().getColor(this.colorSnackBarText));
            snackbar.setAction((CharSequence)activity.getString(buttonName), new View.OnClickListener(){

                public void onClick(View v) {
                    interfaceClick.onClick(v);
                }
            });
            snackbar.setActionTextColor(activity.getResources().getColor(this.colorSnackBarText));
            snackbar.show();
        }
        catch (Exception ignored) {
            Toast.makeText((Context)activity, (int)message, (int)0).show();
        }
    }
}

