goog.provide('shadow.cljs.build_report.ui');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('shadow.api');
goog.require('shadow.dom');
goog.require('goog.format');
goog.require('shadow.markup.react');
var module$node_modules$react_dom$index=shadow.js.require("module$node_modules$react_dom$index", {});
var module$node_modules$react_table$lib$index=shadow.js.require("module$node_modules$react_table$lib$index", {});
goog.require('goog.string.format');
goog.require('goog.string');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.build_report !== 'undefined') && (typeof shadow.cljs.build_report.ui !== 'undefined') && (typeof shadow.cljs.build_report.ui.state_ref !== 'undefined')){
} else {
shadow.cljs.build_report.ui.state_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.build_report !== 'undefined') && (typeof shadow.cljs.build_report.ui !== 'undefined') && (typeof shadow.cljs.build_report.ui.root !== 'undefined')){
} else {
shadow.cljs.build_report.ui.root = shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1("root");
}
shadow.cljs.build_report.ui.filesize = (function shadow$cljs$build_report$ui$filesize(size){
return goog.format.numBytesToString(size,(2),true,true);
});
shadow.cljs.build_report.ui.main_table_container = shadow.markup.css.element_STAR_("div","shadow-cljs-build-report-ui--main-table-container",(function (_){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-width","max-width",-1939924051),(800)], null);
}));
shadow.cljs.build_report.ui.sub_table_container = shadow.markup.css.element_STAR_("div","shadow-cljs-build-report-ui--sub-table-container",(function (_){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(5),(70),(20),(40)], null)], null);
}));
shadow.cljs.build_report.ui.sub_table_header = shadow.markup.css.element_STAR_("div","shadow-cljs-build-report-ui--sub-table-header",(function (_){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1.3em",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941),(10)], null);
}));
shadow.cljs.build_report.ui.rt_columns = cljs.core.clj__GT_js(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),"group-name",new cljs.core.Keyword(null,"Header","Header",1255420133),"Name",new cljs.core.Keyword(null,"Cell","Cell",53644787),(function (row_obj){
var map__140649 = row_obj.original;
var map__140649__$1 = ((((!((map__140649 == null)))?(((((map__140649.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__140649.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__140649):map__140649);
var row = map__140649__$1;
var group_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140649__$1,new cljs.core.Keyword(null,"group-id","group-id",-1316082778));
var group_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140649__$1,new cljs.core.Keyword(null,"group-name","group-name",-232140110));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"prj","prj",1120246589),group_id)){
return shadow.markup.react.impl.interop.create_element("b",[group_name]);
} else {
return group_name;
}
})], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"id","id",-1388402092),"optimized-size",new cljs.core.Keyword(null,"Header","Header",1255420133),"Optimized",new cljs.core.Keyword(null,"headerClassName","headerClassName",-143432465),"numeric",new cljs.core.Keyword(null,"className","className",-1983287057),"numeric",new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),(120),new cljs.core.Keyword(null,"Cell","Cell",53644787),(function (row_obj){
return shadow.cljs.build_report.ui.filesize(row_obj.value);
}),new cljs.core.Keyword(null,"accessor","accessor",-25476721),(function (p1__140647_SHARP_){
return new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725).cljs$core$IFn$_invoke$arity$1(p1__140647_SHARP_);
})], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"id","id",-1388402092),"group-ptc",new cljs.core.Keyword(null,"Header","Header",1255420133),"%",new cljs.core.Keyword(null,"headerClassName","headerClassName",-143432465),"numeric",new cljs.core.Keyword(null,"className","className",-1983287057),"numeric",new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),(70),new cljs.core.Keyword(null,"Cell","Cell",53644787),(function (row_obj){
var G__140651 = "%.1f %%";
var G__140652 = row_obj.value;
return goog.string.format(G__140651,G__140652);
}),new cljs.core.Keyword(null,"accessor","accessor",-25476721),(function (p1__140648_SHARP_){
return new cljs.core.Keyword(null,"group-pct","group-pct",-1926071629).cljs$core$IFn$_invoke$arity$1(p1__140648_SHARP_);
})], null)], null));
shadow.cljs.build_report.ui.rt_sub_columns = cljs.core.clj__GT_js(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),"resource-name",new cljs.core.Keyword(null,"Header","Header",1255420133),"Name",new cljs.core.Keyword(null,"accessor","accessor",-25476721),(function (p1__140653_SHARP_){
return new cljs.core.Keyword(null,"resource-name","resource-name",2001617100).cljs$core$IFn$_invoke$arity$1(p1__140653_SHARP_);
})], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"id","id",-1388402092),"optimized-size",new cljs.core.Keyword(null,"Header","Header",1255420133),"Optimized",new cljs.core.Keyword(null,"headerClassName","headerClassName",-143432465),"numeric",new cljs.core.Keyword(null,"className","className",-1983287057),"numeric",new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),(120),new cljs.core.Keyword(null,"Cell","Cell",53644787),(function (row_obj){
return shadow.cljs.build_report.ui.filesize(row_obj.value);
}),new cljs.core.Keyword(null,"accessor","accessor",-25476721),(function (p1__140654_SHARP_){
return new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725).cljs$core$IFn$_invoke$arity$1(p1__140654_SHARP_);
})], null)], null));
shadow.cljs.build_report.ui.overview = (function shadow$cljs$build_report$ui$overview(){
var sources_by_name = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),cljs.core.identity),new cljs.core.Keyword(null,"build-sources","build-sources",-1750353374).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(shadow.cljs.build_report.ui.state_ref))));
var map__140655 = cljs.core.deref(shadow.cljs.build_report.ui.state_ref);
var map__140655__$1 = ((((!((map__140655 == null)))?(((((map__140655.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__140655.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__140655):map__140655);
var build_sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140655__$1,new cljs.core.Keyword(null,"build-sources","build-sources",-1750353374));
var build_modules = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140655__$1,new cljs.core.Keyword(null,"build-modules","build-modules",-1146364107));
var display_modules = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (sources_by_name,map__140655,map__140655__$1,build_sources,build_modules){
return (function (p__140657){
var map__140658 = p__140657;
var map__140658__$1 = ((((!((map__140658 == null)))?(((((map__140658.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__140658.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__140658):map__140658);
var mod = map__140658__$1;
var source_bytes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140658__$1,new cljs.core.Keyword(null,"source-bytes","source-bytes",2043726942));
var total = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),cljs.core.vals(source_bytes));
var rows = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725),cljs.core._GT_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (total,map__140658,map__140658__$1,mod,source_bytes,sources_by_name,map__140655,map__140655__$1,build_sources,build_modules){
return (function (p__140660){
var vec__140661 = p__140660;
var group = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__140661,(0),null);
var vec__140664 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__140661,(1),null);
var item = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__140664,(0),null);
var items = vec__140664;
var vec__140667 = group;
var group_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__140667,(0),null);
var group_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__140667,(1),null);
var group_size = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725),items));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(item,new cljs.core.Keyword(null,"group-id","group-id",-1316082778),group_id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"group-name","group-name",-232140110),group_name,new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725),group_size,new cljs.core.Keyword(null,"group-pct","group-pct",-1926071629),((100) * (group_size / total)),new cljs.core.Keyword(null,"item-count","item-count",8658772),cljs.core.count(items),new cljs.core.Keyword(null,"items","items",1031954938),items], 0));
});})(total,map__140658,map__140658__$1,mod,source_bytes,sources_by_name,map__140655,map__140655__$1,build_sources,build_modules))
,cljs.core.group_by(new cljs.core.Keyword(null,"group","group",582596132),cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725),cljs.core._GT_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (total,map__140658,map__140658__$1,mod,source_bytes,sources_by_name,map__140655,map__140655__$1,build_sources,build_modules){
return (function (p__140670){
var vec__140671 = p__140670;
var resource_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__140671,(0),null);
var optimized_size = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__140671,(1),null);
var map__140674 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(sources_by_name,resource_name);
var map__140674__$1 = ((((!((map__140674 == null)))?(((((map__140674.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__140674.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__140674):map__140674);
var src_info = map__140674__$1;
var npm_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140674__$1,new cljs.core.Keyword(null,"npm-info","npm-info",295306408));
var pom_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140674__$1,new cljs.core.Keyword(null,"pom-info","pom-info",-2111983790));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src_info,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name,new cljs.core.Keyword(null,"group","group",582596132),(function (){var or__3949__auto__ = (function (){var and__3938__auto__ = npm_info;
if(cljs.core.truth_(and__3938__auto__)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"npm","npm",785664792),new cljs.core.Keyword(null,"package-name","package-name",350612733).cljs$core$IFn$_invoke$arity$1(npm_info)], null);
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = (function (){var and__3938__auto__ = pom_info;
if(cljs.core.truth_(and__3938__auto__)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"jar","jar",-1059959581),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(pom_info))].join('')], null);
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(or__3949__auto____$1)){
return or__3949__auto____$1;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"prj","prj",1120246589),"Project Files"], null);
}
}
})(),new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725),optimized_size], null)], 0));
});})(total,map__140658,map__140658__$1,mod,source_bytes,sources_by_name,map__140655,map__140655__$1,build_sources,build_modules))
,source_bytes))))));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(mod,new cljs.core.Keyword(null,"rows","rows",850049680),rows);
});})(sources_by_name,map__140655,map__140655__$1,build_sources,build_modules))
,build_modules);
var sub_row = ((function (sources_by_name,map__140655,map__140655__$1,build_sources,build_modules,display_modules){
return (function shadow$cljs$build_report$ui$overview_$_sub_row(row){
var map__140676 = row.original;
var map__140676__$1 = ((((!((map__140676 == null)))?(((((map__140676.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__140676.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__140676):map__140676);
var row__$1 = map__140676__$1;
var npm_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140676__$1,new cljs.core.Keyword(null,"npm-info","npm-info",295306408));
var pom_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140676__$1,new cljs.core.Keyword(null,"pom-info","pom-info",-2111983790));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140676__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var item_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140676__$1,new cljs.core.Keyword(null,"item-count","item-count",8658772));
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140676__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var G__140678 = cljs.core.PersistentArrayMap.EMPTY;
var G__140679 = (cljs.core.truth_(pom_info)?(function (){var G__140682 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"coordinate","coordinate",-112811209).cljs$core$IFn$_invoke$arity$1(pom_info)], 0));
return (shadow.cljs.build_report.ui.sub_table_header.cljs$core$IFn$_invoke$arity$1 ? shadow.cljs.build_report.ui.sub_table_header.cljs$core$IFn$_invoke$arity$1(G__140682) : shadow.cljs.build_report.ui.sub_table_header.call(null,G__140682));
})():null);
var G__140680 = (cljs.core.truth_(npm_info)?(function (){var G__140683 = ["npm: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"package-name","package-name",350612733).cljs$core$IFn$_invoke$arity$1(npm_info)),"@",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(npm_info))].join('');
return (shadow.cljs.build_report.ui.sub_table_header.cljs$core$IFn$_invoke$arity$1 ? shadow.cljs.build_report.ui.sub_table_header.cljs$core$IFn$_invoke$arity$1(G__140683) : shadow.cljs.build_report.ui.sub_table_header.call(null,G__140683));
})():null);
var G__140681 = shadow.markup.react.$.cljs$core$IFn$_invoke$arity$variadic(module$node_modules$react_table$lib$index["default"],cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([({"data": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(items), "columns": shadow.cljs.build_report.ui.rt_sub_columns, "showPagination": false, "defaultPageSize": (250), "minRows": item_count, "className": "-sriped -highlight"})], 0));
return (shadow.cljs.build_report.ui.sub_table_container.cljs$core$IFn$_invoke$arity$4 ? shadow.cljs.build_report.ui.sub_table_container.cljs$core$IFn$_invoke$arity$4(G__140678,G__140679,G__140680,G__140681) : shadow.cljs.build_report.ui.sub_table_container.call(null,G__140678,G__140679,G__140680,G__140681));
});})(sources_by_name,map__140655,map__140655__$1,build_sources,build_modules,display_modules))
;
return shadow.markup.react.impl.interop.create_element("div",[(function (){var iter__4324__auto__ = ((function (sources_by_name,map__140655,map__140655__$1,build_sources,build_modules,display_modules,sub_row){
return (function shadow$cljs$build_report$ui$overview_$_iter__140684(s__140685){
return (new cljs.core.LazySeq(null,((function (sources_by_name,map__140655,map__140655__$1,build_sources,build_modules,display_modules,sub_row){
return (function (){
var s__140685__$1 = s__140685;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__140685__$1);
if(temp__5457__auto__){
var s__140685__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__140685__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__140685__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__140687 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__140686 = (0);
while(true){
if((i__140686 < size__4323__auto__)){
var map__140688 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__140686);
var map__140688__$1 = ((((!((map__140688 == null)))?(((((map__140688.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__140688.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__140688):map__140688);
var mod = map__140688__$1;
var module_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140688__$1,new cljs.core.Keyword(null,"module-id","module-id",376972113));
var js_size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140688__$1,new cljs.core.Keyword(null,"js-size","js-size",-582454603));
var gzip_size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140688__$1,new cljs.core.Keyword(null,"gzip-size","gzip-size",1012129871));
var rows = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140688__$1,new cljs.core.Keyword(null,"rows","rows",850049680));
cljs.core.chunk_append(b__140687,(function (){var G__140690 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.name(module_id)], null);
var G__140691 = shadow.markup.react.impl.interop.create_element("h3",[["Module: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([module_id], 0)))," [JS: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.build_report.ui.filesize(js_size)),"] [GZIP: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.build_report.ui.filesize(gzip_size)),"]"].join('')]);
var G__140692 = shadow.markup.react.$.cljs$core$IFn$_invoke$arity$variadic(module$node_modules$react_table$lib$index["default"],cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([({"data": rows, "columns": shadow.cljs.build_report.ui.rt_columns, "showPagination": false, "defaultPageSize": (250), "minRows": cljs.core.count(rows), "expanderDefaults": ({"width": (40)}), "className": "-sriped -highlight", "SubComponent": sub_row})], 0));
return (shadow.cljs.build_report.ui.main_table_container.cljs$core$IFn$_invoke$arity$3 ? shadow.cljs.build_report.ui.main_table_container.cljs$core$IFn$_invoke$arity$3(G__140690,G__140691,G__140692) : shadow.cljs.build_report.ui.main_table_container.call(null,G__140690,G__140691,G__140692));
})());

var G__140698 = (i__140686 + (1));
i__140686 = G__140698;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__140687),shadow$cljs$build_report$ui$overview_$_iter__140684(cljs.core.chunk_rest(s__140685__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__140687),null);
}
} else {
var map__140693 = cljs.core.first(s__140685__$2);
var map__140693__$1 = ((((!((map__140693 == null)))?(((((map__140693.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__140693.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__140693):map__140693);
var mod = map__140693__$1;
var module_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140693__$1,new cljs.core.Keyword(null,"module-id","module-id",376972113));
var js_size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140693__$1,new cljs.core.Keyword(null,"js-size","js-size",-582454603));
var gzip_size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140693__$1,new cljs.core.Keyword(null,"gzip-size","gzip-size",1012129871));
var rows = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140693__$1,new cljs.core.Keyword(null,"rows","rows",850049680));
return cljs.core.cons((function (){var G__140695 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.name(module_id)], null);
var G__140696 = shadow.markup.react.impl.interop.create_element("h3",[["Module: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([module_id], 0)))," [JS: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.build_report.ui.filesize(js_size)),"] [GZIP: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.build_report.ui.filesize(gzip_size)),"]"].join('')]);
var G__140697 = shadow.markup.react.$.cljs$core$IFn$_invoke$arity$variadic(module$node_modules$react_table$lib$index["default"],cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([({"data": rows, "columns": shadow.cljs.build_report.ui.rt_columns, "showPagination": false, "defaultPageSize": (250), "minRows": cljs.core.count(rows), "expanderDefaults": ({"width": (40)}), "className": "-sriped -highlight", "SubComponent": sub_row})], 0));
return (shadow.cljs.build_report.ui.main_table_container.cljs$core$IFn$_invoke$arity$3 ? shadow.cljs.build_report.ui.main_table_container.cljs$core$IFn$_invoke$arity$3(G__140695,G__140696,G__140697) : shadow.cljs.build_report.ui.main_table_container.call(null,G__140695,G__140696,G__140697));
})(),shadow$cljs$build_report$ui$overview_$_iter__140684(cljs.core.rest(s__140685__$2)));
}
} else {
return null;
}
break;
}
});})(sources_by_name,map__140655,map__140655__$1,build_sources,build_modules,display_modules,sub_row))
,null,null));
});})(sources_by_name,map__140655,map__140655__$1,build_sources,build_modules,display_modules,sub_row))
;
return iter__4324__auto__(display_modules);
})()]);
});
shadow.cljs.build_report.ui.start = (function shadow$cljs$build_report$ui$start(){
console.log("start");

var G__140699 = shadow.cljs.build_report.ui.overview();
var G__140700 = shadow.cljs.build_report.ui.root;
return module$node_modules$react_dom$index.render(G__140699,G__140700);
});
shadow.cljs.build_report.ui.stop = (function shadow$cljs$build_report$ui$stop(){
module$node_modules$react_dom$index.unmountComponentAtNode(shadow.cljs.build_report.ui.root);

return console.log("stop");
});
shadow.cljs.build_report.ui.init = (function shadow$cljs$build_report$ui$init(bundle_data){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(shadow.cljs.build_report.ui.state_ref,cljs.core.merge,bundle_data);

return shadow.cljs.build_report.ui.start();
});
goog.exportSymbol('shadow.cljs.build_report.ui.init', shadow.cljs.build_report.ui.init);
var G__140701_140703 = "shadow.cljs.build-report.ui";
var G__140702_140704 = cljs.core.PersistentArrayMap.EMPTY;
shadow.api.ns_ready_STAR_(G__140701_140703,G__140702_140704);

//# sourceMappingURL=shadow.cljs.build_report.ui.js.map
