/*
 * Decompiled with CFR 0.152.
 */
package nectec.thai.widget.date;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.widget.NumberPicker;
import java.util.Calendar;
import nectec.thai.widget.ViewUtils;
import nectec.thai.widget.date.DatePopup;
import nectec.thai.widget.date.DateView;
import th.or.nectec.thai.widget.R;

public class DatePickerDialog
extends AlertDialog
implements DatePopup,
NumberPicker.OnValueChangeListener {
    private static final String[] THAI_MONTH = new String[]{"\u0e21\u0e01\u0e23\u0e32\u0e04\u0e21", "\u0e01\u0e38\u0e21\u0e20\u0e32\u0e1e\u0e31\u0e19\u0e18\u0e4c", "\u0e21\u0e35\u0e19\u0e32\u0e04\u0e21", "\u0e40\u0e21\u0e29\u0e32\u0e22\u0e19", "\u0e1e\u0e24\u0e29\u0e20\u0e32\u0e04\u0e21", "\u0e21\u0e34\u0e16\u0e38\u0e19\u0e32\u0e22\u0e19", "\u0e01\u0e23\u0e01\u0e0e\u0e32\u0e04\u0e21", "\u0e2a\u0e34\u0e07\u0e2b\u0e32\u0e04\u0e21", "\u0e01\u0e31\u0e19\u0e22\u0e32\u0e22\u0e19", "\u0e15\u0e38\u0e25\u0e32\u0e04\u0e21", "\u0e1e\u0e24\u0e28\u0e08\u0e34\u0e01\u0e32\u0e22\u0e19", "\u0e18\u0e31\u0e19\u0e27\u0e32\u0e04\u0e21"};
    protected final NumberPicker dayPicker;
    protected final NumberPicker monthPicker;
    protected final NumberPicker yearPicker;
    private Calendar calendar;
    private DateView.DatePickerCallback callback;
    private final DialogInterface.OnClickListener onPositiveButtonClick = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialogInterface, int i) {
            View currentFocus = DatePickerDialog.this.getCurrentFocus();
            if (currentFocus != null) {
                currentFocus.clearFocus();
            }
            if (DatePickerDialog.this.callback != null) {
                DatePickerDialog.this.callback.onPicked(DatePickerDialog.this, DatePickerDialog.this.calendar);
            }
            DatePickerDialog.this.dismiss();
        }
    };
    private final DialogInterface.OnClickListener onNegativeButtonClick = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialogInterface, int i) {
            if (DatePickerDialog.this.callback != null) {
                DatePickerDialog.this.callback.onCancel();
            }
            DatePickerDialog.this.dismiss();
        }
    };
    private Calendar maxDate;
    private Calendar minDate;

    public DatePickerDialog(Context context) {
        this(context, null);
    }

    public DatePickerDialog(Context context, DateView.DatePickerCallback datePickerCallback) {
        this(context, Calendar.getInstance(), datePickerCallback);
    }

    public DatePickerDialog(Context context, Calendar calendar, DateView.DatePickerCallback datePickerCallback) {
        super(context);
        this.calendar = calendar;
        this.callback = datePickerCallback;
        View view = ViewUtils.inflateView(this.getContext(), R.layout.thwig_dialog_date_picker);
        this.setView(view);
        this.dayPicker = (NumberPicker)view.findViewById(R.id.day);
        this.dayPicker.setOnValueChangedListener((NumberPicker.OnValueChangeListener)this);
        this.dayPicker.setMinValue(1);
        this.dayPicker.setMaxValue(calendar.getActualMaximum(5));
        this.monthPicker = (NumberPicker)view.findViewById(R.id.month);
        this.monthPicker.setOnValueChangedListener((NumberPicker.OnValueChangeListener)this);
        this.monthPicker.setMinValue(0);
        this.monthPicker.setMaxValue(11);
        this.monthPicker.setDisplayedValues(THAI_MONTH);
        this.yearPicker = (NumberPicker)view.findViewById(R.id.year);
        this.yearPicker.setOnValueChangedListener((NumberPicker.OnValueChangeListener)this);
        this.yearPicker.setMinValue(2400);
        this.yearPicker.setMaxValue(2600);
        this.setButton(-1, this.getContext().getString(R.string.ok), this.onPositiveButtonClick);
        this.setButton(-2, this.getContext().getString(R.string.cancel), this.onNegativeButtonClick);
        this.updateDate(calendar);
    }

    public final void updateDate(Calendar calendar) {
        this.updateDate(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    @Override
    public void updateDate(int year, int month, int dayOfMonth) {
        this.calendar.set(year, month, dayOfMonth);
        if (this.dayPicker != null) {
            this.dayPicker.setValue(dayOfMonth);
            this.dayPicker.setMaxValue(this.calendar.getActualMaximum(5));
            this.monthPicker.setValue(month);
            this.yearPicker.setValue(year + 543);
        }
    }

    @Override
    public int getYear() {
        return this.calendar.get(1);
    }

    @Override
    public int getMonth() {
        return this.calendar.get(2);
    }

    @Override
    public int getDayOfMonth() {
        return this.calendar.get(5);
    }

    @Override
    public void setMaxDate(int year, int month, int dayOfMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, dayOfMonth);
        this.setMaxDate(calendar);
    }

    @Override
    public void setMinDate(int year, int month, int dayOfMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, dayOfMonth);
        this.setMinDate(calendar);
    }

    @Override
    public void setCallback(DateView.DatePickerCallback callback) {
        this.callback = callback;
    }

    public void setMaxDateIsToday() {
        this.setMaxDate(Calendar.getInstance());
    }

    public void setMaxDate(Calendar maxDate) {
        this.maxDate = maxDate;
        this.yearPicker.setMaxValue(maxDate.get(1) + 543);
        this.updateMaxValueIfMaxDateSet();
        if (this.calendar.compareTo(maxDate) > 0) {
            this.updateDate(maxDate);
        }
    }

    public void setMinDateIsToday() {
        this.setMinDate(Calendar.getInstance());
    }

    public void setMinDate(Calendar minDate) {
        this.minDate = minDate;
        this.yearPicker.setMinValue(minDate.get(1) + 543);
        this.updateMinValueIfMinDateSet();
        if (this.calendar.compareTo(minDate) < 0) {
            this.updateDate(minDate);
        }
    }

    @Override
    public void show(int year, int month, int dayOfMonth) {
        this.updateDate(year, month, dayOfMonth);
        this.show();
    }

    @Override
    public void show(Calendar calendar) {
        this.updateDate(calendar);
        this.show();
    }

    @Override
    public void setPopupTitle(String title) {
        this.setTitle(title);
    }

    public void onValueChange(NumberPicker numberPicker, int i, int i1) {
        this.updateValueAndUi();
    }

    protected void updateValueAndUi() {
        this.trimDayOverMaxDayOfNewMonth();
        this.updateMaxValueIfMaxDateSet();
        this.updateMinValueIfMinDateSet();
    }

    private void trimDayOverMaxDayOfNewMonth() {
        Calendar newCalendar = this.newCalendarFromPicker();
        this.updateDate(newCalendar);
    }

    protected Calendar newCalendarFromPicker() {
        Calendar newCalendar = Calendar.getInstance();
        newCalendar.set(this.yearPicker.getValue() - 543, this.monthPicker.getValue(), 1);
        if (this.dayPicker.getValue() > newCalendar.getActualMaximum(5)) {
            this.dayPicker.setValue(newCalendar.getActualMaximum(5));
        }
        this.dayPicker.setMaxValue(newCalendar.getActualMaximum(5));
        newCalendar.set(5, this.dayPicker.getValue());
        return newCalendar;
    }

    private void updateMaxValueIfMaxDateSet() {
        if (this.maxDate == null) {
            return;
        }
        Calendar newCalendar = Calendar.getInstance();
        newCalendar.set(this.yearPicker.getValue() - 543, this.monthPicker.getValue(), 1);
        if (this.yearPicker.getValue() == this.maxDate.get(1) + 543) {
            this.monthPicker.setOnValueChangedListener(null);
            this.dayPicker.setOnValueChangedListener(null);
            int maxMonth = this.maxDate.get(2);
            this.monthPicker.setMaxValue(maxMonth);
            if (this.monthPicker.getValue() == maxMonth) {
                int maxDayOfMonth = this.maxDate.get(5);
                this.dayPicker.setMaxValue(maxDayOfMonth);
            }
            newCalendar.set(this.yearPicker.getValue() - 543, this.monthPicker.getValue(), this.dayPicker.getValue());
            this.updateDate(newCalendar);
            this.monthPicker.setOnValueChangedListener((NumberPicker.OnValueChangeListener)this);
            this.dayPicker.setOnValueChangedListener((NumberPicker.OnValueChangeListener)this);
        } else {
            this.monthPicker.setMaxValue(11);
        }
    }

    private void updateMinValueIfMinDateSet() {
        if (this.minDate == null) {
            return;
        }
        Calendar newCalendar = Calendar.getInstance();
        newCalendar.set(this.yearPicker.getValue() - 543, this.monthPicker.getValue(), 1);
        if (this.yearPicker.getValue() == this.minDate.get(1) + 543) {
            this.monthPicker.setOnValueChangedListener(null);
            this.dayPicker.setOnValueChangedListener(null);
            int minMonth = this.minDate.get(2);
            this.monthPicker.setMinValue(minMonth);
            String[] monthDisplay = new String[12 - minMonth];
            System.arraycopy(THAI_MONTH, minMonth, monthDisplay, 0, monthDisplay.length);
            this.monthPicker.setDisplayedValues(monthDisplay);
            if (this.monthPicker.getValue() == minMonth) {
                int minDayOfMonth = this.minDate.get(5);
                this.dayPicker.setMinValue(minDayOfMonth);
            } else {
                this.dayPicker.setMinValue(1);
            }
            newCalendar.set(this.yearPicker.getValue() - 543, this.monthPicker.getValue(), this.dayPicker.getValue());
            this.updateDate(newCalendar);
            this.monthPicker.setOnValueChangedListener((NumberPicker.OnValueChangeListener)this);
            this.dayPicker.setOnValueChangedListener((NumberPicker.OnValueChangeListener)this);
        } else {
            this.monthPicker.setMinValue(0);
            this.monthPicker.setDisplayedValues(THAI_MONTH);
            this.dayPicker.setMinValue(1);
        }
    }
}

