/*
 * Decompiled with CFR 0.152.
 */
package nectec.thai.widget.date;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Parcelable;
import android.support.v7.widget.AppCompatEditText;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import java.util.Calendar;
import java.util.Locale;
import nectec.thai.date.DatePrinter;
import nectec.thai.widget.ViewUtils;
import nectec.thai.widget.date.CalendarSavedState;
import nectec.thai.widget.date.DatePickerDialog;
import nectec.thai.widget.date.DatePopup;
import nectec.thai.widget.date.DateView;

public class DatePicker
extends AppCompatEditText
implements DateView {
    protected static final String HINT_MESSAGE = "\u0e23\u0e30\u0e1a\u0e38\u0e27\u0e31\u0e19\u0e17\u0e35";
    private final DatePopup popup;
    private Calendar calendar;
    private DateView.DatePickerCallback callback;
    private OnDateChangedListener onDateChangedListener;
    private final DateView.DatePickerCallback datePickerCallback = new DateView.DatePickerCallback(){

        @Override
        public void onPicked(DateView view, Calendar calendar) {
            DatePicker.this.setCalendar(calendar);
            if (DatePicker.this.callback != null) {
                DatePicker.this.callback.onPicked(DatePicker.this, calendar);
            }
        }

        @Override
        public void onCancel() {
            DatePicker.this.removeCalendar();
        }
    };
    private boolean undefinedAsDefault;

    public DatePicker(Context context) {
        this(context, null);
    }

    public DatePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public DatePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.undefinedAsDefault) {
            this.setCalendar(this.defaultCalendar());
        }
        if (TextUtils.isEmpty((CharSequence)this.getHint())) {
            this.setHint(HINT_MESSAGE);
        }
        ViewUtils.updatePaddingRight((View)this);
        this.popup = new DatePickerDialog(context, this.datePickerCallback);
    }

    public final void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.setText(DatePrinter.print(calendar));
        if (this.onDateChangedListener != null) {
            this.onDateChangedListener.onDateChanged(calendar);
        }
    }

    private Calendar defaultCalendar() {
        Locale locale = this.getContext().getResources().getConfiguration().locale;
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setFirstDayOfWeek(1);
        return calendar;
    }

    public void setUndefinedAsDefault() {
        this.removeCalendar();
        this.undefinedAsDefault = true;
    }

    private void removeCalendar() {
        this.callback = null;
        this.calendar = null;
        if (this.onDateChangedListener != null) {
            this.onDateChangedListener.onDateChanged(null);
        }
        this.setText(null);
    }

    public Calendar getCalendar() {
        return this.calendar == null ? null : (Calendar)this.calendar.clone();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.setFocusable(false);
        this.setLongClickable(false);
        this.setClickable(true);
    }

    public boolean performClick() {
        if (this.calendar == null) {
            this.calendar = this.defaultCalendar();
        }
        this.popup.show(this.calendar);
        return super.performClick();
    }

    @Override
    public void updateDate(int year, int month, int dayOfMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, dayOfMonth);
        this.setCalendar(calendar);
    }

    @Override
    public int getYear() {
        return this.calendar.get(1);
    }

    @Override
    public int getMonth() {
        return this.calendar.get(2);
    }

    @Override
    public int getDayOfMonth() {
        return this.calendar.get(5);
    }

    @Override
    public void setMaxDate(int year, int month, int dayOfMonth) {
        Calendar maxCalendar = this.defaultCalendar();
        maxCalendar.set(year, month, dayOfMonth);
        if (this.calendar.compareTo(maxCalendar) > 0) {
            this.setCalendar(maxCalendar);
        }
        this.popup.setMaxDate(year, month, dayOfMonth);
    }

    @Override
    public void setMinDate(int year, int month, int dayOfMonth) {
        Calendar maxCalendar = this.defaultCalendar();
        maxCalendar.set(year, month, dayOfMonth);
        if (this.calendar.compareTo(maxCalendar) < 0) {
            this.setCalendar(maxCalendar);
        }
        this.popup.setMinDate(year, month, dayOfMonth);
    }

    @Override
    public void setCallback(DateView.DatePickerCallback callback) {
        this.callback = callback;
    }

    public Parcelable onSaveInstanceState() {
        if (this.calendar == null) {
            return super.onSaveInstanceState();
        }
        Parcelable parcelable = super.onSaveInstanceState();
        CalendarSavedState savedState = new CalendarSavedState(parcelable);
        savedState.setCalendar(this.calendar);
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof CalendarSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        CalendarSavedState ss = (CalendarSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setCalendar(ss.getCalendar());
    }

    public void setOnDateChangedListener(OnDateChangedListener onDateChangedListener) {
        this.onDateChangedListener = onDateChangedListener;
    }

    public void setPopupTitle(String title) {
        this.popup.setPopupTitle(title);
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(Calendar var1);
    }
}

