/*
 * Decompiled with CFR 0.152.
 */
package nectec.thai.widget.address;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SearchView;
import android.widget.TextView;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nectec.thai.address.Address;
import nectec.thai.address.AddressEntity;
import nectec.thai.address.AddressRepository;
import nectec.thai.address.District;
import nectec.thai.address.Province;
import nectec.thai.address.SubDistrict;
import nectec.thai.widget.address.AddressListAdapter;
import nectec.thai.widget.address.AddressPopup;
import nectec.thai.widget.address.AddressView;
import nectec.thai.widget.address.ArrayStack;
import nectec.thai.widget.address.repository.AddressRepositoryImpl;
import nectec.thai.widget.address.repository.DistrictRepository;
import nectec.thai.widget.address.repository.ProvinceRepository;
import nectec.thai.widget.address.repository.SubDistrictRepository;
import th.or.nectec.thai.widget.R;

public class AddressPickerDialog
extends Dialog
implements AddressPopup,
AdapterView.OnItemClickListener {
    private ArrayStack<AddressEntity> addressStack = new ArrayStack();
    private TextView header;
    private TextView breadcrumb;
    private ListView list;
    private SearchView search;
    private AddressRepositoryImpl addressRepository;
    private AddressRepository<Province> provinceRepository;
    private AddressRepository<District> districtRepository;
    private AddressRepository<SubDistrict> subDistrictRepository;
    private AddressView.OnAddressChangedListener onAddressChangedListener;
    private AddressListAdapter addressListAdapter;

    public AddressPickerDialog(Context context) {
        this(context, null);
    }

    public AddressPickerDialog(Context context, AddressView.OnAddressChangedListener onAddressChangedListener) {
        this(context, 0, onAddressChangedListener);
    }

    public AddressPickerDialog(Context context, int themeResId, AddressView.OnAddressChangedListener onAddressChangedListener) {
        super(context, themeResId);
        this.requestWindowFeature(1);
        this.addressRepository = AddressRepositoryImpl.getInstance(context);
        this.provinceRepository = ProvinceRepository.getInstance(context);
        this.districtRepository = DistrictRepository.getInstance(context);
        this.subDistrictRepository = SubDistrictRepository.getInstance(context);
        this.onAddressChangedListener = onAddressChangedListener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.thwig_dialog_address_picker);
        this.breadcrumb = (TextView)this.findViewById(R.id.breadcrumb);
        this.header = (TextView)this.findViewById(R.id.header);
        this.list = (ListView)this.findViewById(R.id.picker_list);
        this.search = (SearchView)this.findViewById(R.id.search);
        this.search.setOnCloseListener(new SearchView.OnCloseListener(){

            public boolean onClose() {
                return false;
            }
        });
        this.search.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String query) {
                return true;
            }

            public boolean onQueryTextChange(String query) {
                AddressPickerDialog.this.addressListAdapter.getFilter().filter((CharSequence)query);
                return true;
            }
        });
        this.list.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.findViewById(R.id.back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AddressPickerDialog.this.onBackPressed();
            }
        });
        this.switchPage();
    }

    public void onBackPressed() {
        if (this.addressStack.isEmpty()) {
            this.onAddressChangedListener.onAddressCanceled();
            this.dismiss();
            return;
        }
        this.addressStack.pop();
        this.switchPage();
    }

    public AddressPickerDialog setProvinceRepository(AddressRepository<Province> province) {
        this.provinceRepository = province;
        return this;
    }

    public AddressPickerDialog setDistrictRepository(AddressRepository<District> districtRepository) {
        this.districtRepository = districtRepository;
        return this;
    }

    public AddressPickerDialog setSubDistrictRepository(AddressRepository<SubDistrict> subDistrictRepository) {
        this.subDistrictRepository = subDistrictRepository;
        return this;
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
        this.addressStack.push((AddressEntity)this.addressListAdapter.getItem(position));
        this.switchPage();
    }

    private void switchPage() {
        this.updateBreadCrumb();
        if (this.addressStack.isEmpty()) {
            List<Province> provinceList = this.provinceRepository.find();
            Collections.sort(provinceList);
            this.updateDialog(R.string.thwig_choose_province, provinceList);
            return;
        }
        AddressEntity choosedEntity = this.addressStack.peek();
        if (choosedEntity instanceof Province) {
            List<District> districtList = this.districtRepository.findByParentCode(choosedEntity.getCode());
            Collections.sort(districtList);
            this.updateDialog(R.string.thwig_choose_district, districtList);
        } else if (choosedEntity instanceof District) {
            List<SubDistrict> subDistrictList = this.subDistrictRepository.findByParentCode(choosedEntity.getCode());
            Collections.sort(subDistrictList);
            this.updateDialog(R.string.thwig_choose_subdistrict, subDistrictList);
        } else if (choosedEntity instanceof SubDistrict) {
            this.notifyAddressChange(choosedEntity.getCode());
            this.dismiss();
        }
    }

    private void updateBreadCrumb() {
        if (this.addressStack.isEmpty()) {
            this.breadcrumb.setText((CharSequence)"");
            this.breadcrumb.setVisibility(8);
            return;
        }
        StringBuilder builder = new StringBuilder();
        Iterator<AddressEntity> iterator = this.addressStack.getIterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next().getName());
            if (!iterator.hasNext()) continue;
            builder.append("  >  ");
        }
        this.breadcrumb.setText((CharSequence)builder.toString());
        this.breadcrumb.setVisibility(0);
    }

    public void updateDialog(int headerStringResId, List<? extends AddressEntity> addressEntityList) {
        this.header.setText(headerStringResId);
        this.setListAdapter(new AddressListAdapter<AddressEntity>(this.getContext(), addressEntityList));
        this.search.setQueryHint((CharSequence)this.getContext().getString(headerStringResId).replace("\u0e40\u0e25\u0e37\u0e2d\u0e01", "\u0e04\u0e49\u0e19\u0e2b\u0e32"));
        this.search.clearFocus();
        this.search.setIconified(true);
        this.search.setIconified(true);
    }

    private void setListAdapter(AddressListAdapter addressListAdapter) {
        this.addressListAdapter = addressListAdapter;
        this.list.setAdapter((ListAdapter)addressListAdapter);
    }

    private void notifyAddressChange(String code) {
        Address address = this.addressRepository.findByCode(code);
        this.onAddressChangedListener.onAddressChanged(address);
    }

    @Override
    public void show(String addressCode) {
        this.show(this.addressRepository.findByCode(addressCode));
    }

    @Override
    public void show(Address area) {
        this.addressStack = new ArrayStack();
        if (area != null) {
            this.addressStack.push(area.getProvince());
            this.addressStack.push(area.getDistrict());
        }
        this.show();
    }

    @Override
    public void setOnAddressChangedListener(AddressView.OnAddressChangedListener onAddressChangedListener) {
        this.onAddressChangedListener = onAddressChangedListener;
    }
}

