/*
 * Decompiled with CFR 0.152.
 */
package nectec.thai.widget.address;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import nectec.thai.address.AddressEntity;
import th.or.nectec.thai.widget.R;

class AddressListAdapter<T extends AddressEntity>
extends BaseAdapter
implements Filterable {
    private final LayoutInflater mInflater;
    private final Context context;
    private List<T> addressList;
    private List<T> filteredList;

    public AddressListAdapter(Context context, List<T> addressList) {
        this.context = context;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.addAll(addressList);
    }

    public final void addAll(List<T> collection) {
        this.addressList = new ArrayList<T>(collection);
        this.filteredList = new ArrayList<T>(collection);
        this.notifyDataSetChanged();
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.getView(position, convertView, parent);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.thwig_list_item_address, parent, false);
            convertView.setTag((Object)new ViewHolder(convertView));
            convertView.setClickable(false);
        }
        ViewHolder viewHolder = (ViewHolder)convertView.getTag();
        viewHolder.setValue(this.getItem(position));
        return convertView;
    }

    public T getItem(int position) {
        return (T)((AddressEntity)this.filteredList.get(position));
    }

    public int getCount() {
        return this.filteredList.size();
    }

    public long getItemId(int position) {
        return position;
    }

    public Filter getFilter() {
        return new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                if (TextUtils.isEmpty((CharSequence)constraint)) {
                    return null;
                }
                Filter.FilterResults result = new Filter.FilterResults();
                ArrayList<AddressEntity> ts = new ArrayList<AddressEntity>();
                for (AddressEntity t : AddressListAdapter.this.addressList) {
                    if (!t.getName().contains(constraint)) continue;
                    ts.add(t);
                }
                result.count = ts.size();
                result.values = ts;
                return result;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                if (results != null) {
                    AddressListAdapter.this.filteredList = (List)results.values;
                } else {
                    AddressListAdapter.this.filteredList = new ArrayList(AddressListAdapter.this.addressList);
                }
                AddressListAdapter.this.notifyDataSetChanged();
            }
        };
    }

    private class ViewHolder {
        protected TextView name;
        protected TextView code;

        public ViewHolder(View view) {
            this.name = (TextView)view.findViewById(R.id.name);
            this.code = (TextView)view.findViewById(R.id.code);
            this.code.setVisibility(8);
        }

        void setValue(T entity) {
            this.name.setText((CharSequence)entity.getName());
            this.code.setText((CharSequence)AddressListAdapter.this.context.getString(R.string.thwig_address_code_format, new Object[]{entity.getCode()}));
        }
    }
}

