/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.widget.thai.address;

import android.app.Activity;
import android.app.FragmentManager;
import android.content.Context;
import android.widget.TextView;
import android.widget.Toast;
import th.or.nectec.android.widget.thai.OnAddressChangedListener;
import th.or.nectec.android.widget.thai.R;
import th.or.nectec.android.widget.thai.address.AddressPickerDialogFragment;
import th.or.nectec.android.widget.thai.address.InMemoryJsonDistrictRepository;
import th.or.nectec.android.widget.thai.address.InMemoryJsonProvinceRepository;
import th.or.nectec.android.widget.thai.address.InMemoryJsonSubdistrictRepository;
import th.or.nectec.domain.thai.ThaiAddressPrinter;
import th.or.nectec.domain.thai.address.AddressController;
import th.or.nectec.domain.thai.address.AddressPresenter;
import th.or.nectec.domain.thai.address.DistrictRepository;
import th.or.nectec.domain.thai.address.ProvinceRepository;
import th.or.nectec.domain.thai.address.SubdistrictRepository;
import th.or.nectec.entity.thai.Address;

public class AddressPickerHandler
implements OnAddressChangedListener,
AddressPresenter {
    private Context context;
    private Activity activity;
    private AddressPickerDialogFragment addressPickerDialogFragment;
    private OnAddressChangedListener onAddressChangedListener;
    private AddressController addressController;
    private TextView textView;
    private Address address;

    public AddressPickerHandler(TextView view, Context context) {
        this.textView = view;
        this.context = context;
        this.init();
    }

    public void init() {
        if (this.context instanceof Activity) {
            this.activity = (Activity)this.context;
        }
        if (this.activity == null) {
            return;
        }
        FragmentManager fragmentManager = this.activity.getFragmentManager();
        AddressPickerDialogFragment addressPickerDialogFragment = (AddressPickerDialogFragment)fragmentManager.findFragmentByTag("address_dialog");
        this.addressPickerDialogFragment = addressPickerDialogFragment != null ? addressPickerDialogFragment : new AddressPickerDialogFragment();
        this.addressPickerDialogFragment.setOnAddressChangedListener(this);
        this.addressController = new AddressController((SubdistrictRepository)InMemoryJsonSubdistrictRepository.getInstance(this.context), (DistrictRepository)new InMemoryJsonDistrictRepository(this.context), (ProvinceRepository)new InMemoryJsonProvinceRepository(this.context), (AddressPresenter)this);
        this.textView.setText(R.string.please_define_address);
    }

    public void displayAddressInfo(Address address) {
        this.retrieveAddress(address);
    }

    public void alertAddressNotFound() {
        Toast.makeText((Context)this.context, (int)R.string.address_not_found, (int)1).show();
    }

    private void retrieveAddress(Address address) {
        this.address = address;
        this.textView.setText((CharSequence)ThaiAddressPrinter.buildShortAddress((String)address.getSubdistrict().getName(), (String)address.getDistrict().getName(), (String)address.getProvince().getName()));
        if (this.onAddressChangedListener != null) {
            this.onAddressChangedListener.onAddressChanged(address);
        }
    }

    public boolean performClick() {
        boolean handle = false;
        if (this.addressPickerDialogFragment != null) {
            FragmentManager fm = this.activity.getFragmentManager();
            if (!this.addressPickerDialogFragment.isAdded()) {
                this.addressPickerDialogFragment.show(fm, "address_dialog");
                handle = true;
                if (this.address != null) {
                    this.addressPickerDialogFragment.restoreAddressField(this.address);
                }
            }
        }
        return handle;
    }

    public void setAddressCode(String addressCode) {
        this.addressController.showByAddressCode(addressCode);
    }

    public void setAddress(String subdistrict, String district, String province) {
        this.addressController.showByAddressInfo(subdistrict, district, province);
    }

    @Override
    public void onAddressChanged(Address address) {
        this.retrieveAddress(address);
    }

    @Override
    public void onAddressCanceled() {
        if (this.onAddressChangedListener != null) {
            this.onAddressChangedListener.onAddressCanceled();
        }
    }

    public void setOnAddressChangedListener(OnAddressChangedListener onAddressChangedListener) {
        this.onAddressChangedListener = onAddressChangedListener;
    }

    public Address getAddress() {
        return this.address;
    }
}

