/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.widget.thai;

import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.widget.EditText;
import th.or.nectec.domain.thai.Id;

public abstract class AbstractIdHandler
implements TextWatcher {
    protected EditText editText;
    private Id id;

    public AbstractIdHandler(EditText editText) {
        this.editText = editText;
        this.id = this.onCreateNewId(editText.getText().toString());
        this.initialize();
    }

    protected void initialize() {
        this.editText.setInputType(2);
        this.editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.getMaxLenght())});
        this.editText.setKeyListener((KeyListener)DigitsKeyListener.getInstance((boolean)false, (boolean)true));
        this.editText.addTextChangedListener((TextWatcher)this);
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void afterTextChanged(Editable editable) {
        this.onIdChanged(editable);
    }

    public void onIdChanged(Editable editable) {
        Id id = this.onCreateNewId(editable.toString());
        this.updateText(id);
        this.updateErrorMessage(id);
    }

    private void updateText(Id id) {
        if (!id.equals(this.id)) {
            this.id = id;
            this.editText.setText((CharSequence)id.prettyPrint());
            Selection.setSelection((Spannable)this.editText.getEditableText(), (int)this.editText.length());
        }
    }

    private void updateErrorMessage(Id id) {
        if (id.isValidFormat()) {
            this.editText.setError((CharSequence)(id.validate() ? null : this.getErrorMessage()));
        } else {
            this.editText.setError(null);
        }
    }

    public Id getId() {
        return this.id;
    }

    protected abstract int getMaxLenght();

    protected abstract String getErrorMessage();

    protected abstract Id onCreateNewId(String var1);
}

