/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget.address;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import th.or.nectec.android.library.provider.NTTable;
import th.or.nectec.android.library.util.StringUtils;
import th.or.nectec.android.library.widget.address.AddressDialog;

public class AddressView
extends Button
implements AddressDialog.onAddressListener {
    private Activity mActivity;
    private Uri mUri;
    private AddressDialog mDialog;
    String tag = "address-dialog";
    String code;
    String subdistrict;
    String district;
    String province;

    public AddressView(Context context, AttributeSet attrs) {
        super(context, attrs, 16842862);
        if (context instanceof Activity) {
            Activity act = (Activity)context;
            this.initialize(act, NTTable.RefAddress.CONTENT_URI);
        }
    }

    private void initialize(Activity activity, Uri uri) {
        this.mActivity = activity;
        this.mUri = uri;
        this.mDialog = AddressDialog.newInstance(this.mUri);
        this.mDialog.setOnAddressSelectListener(this);
    }

    public boolean performClick() {
        boolean handle = false;
        this.requestFocus();
        if (this.mActivity != null && this.mUri != null) {
            FragmentManager fm = this.mActivity.getFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            Fragment prev = fm.findFragmentByTag(this.tag);
            if (prev != null) {
                ft.remove(prev);
            }
            if (this.mDialog != null) {
                this.mDialog.setOnAddressSelectListener(this);
                this.mDialog.show(fm, this.tag);
                handle = true;
            }
            ft.commit();
        }
        return handle;
    }

    public String getAddressCode() {
        return this.code;
    }

    public String getSubdistrict() {
        return this.subdistrict;
    }

    public String getDistrict() {
        return this.district;
    }

    public String getProvince() {
        return this.province;
    }

    @Override
    public void onAddressSelect(String code, String s, String d, String p) {
        this.setLocale(code, s, d, p);
    }

    public String setLocale(String code, String subdistrict, String district, String province) {
        String str = null;
        if (StringUtils.isEmpty(province, district, subdistrict)) {
            return str;
        }
        if (TextUtils.isEmpty((CharSequence)code)) {
            Cursor findAddressCode = this.getContext().getContentResolver().query(NTTable.RefAddress.CONTENT_URI, new String[]{"address_code"}, "subdistrict=? AND district=? AND province=?", new String[]{subdistrict, district, province}, null);
            if (findAddressCode.moveToNext()) {
                this.code = findAddressCode.getString(0);
            }
        } else {
            this.code = code;
        }
        this.subdistrict = subdistrict;
        this.district = district;
        this.province = province;
        str = province.equals("\u0e01\u0e23\u0e38\u0e07\u0e40\u0e17\u0e1e\u0e21\u0e2b\u0e32\u0e19\u0e04\u0e23") ? "\u0e41\u0e02\u0e27\u0e07" + subdistrict + " \u0e40\u0e02\u0e15" + district + " " + province : "\u0e15." + subdistrict + " \u0e2d." + district + " \u0e08." + province;
        this.setText(str);
        return str;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.code = this.code;
        ss.province = this.province;
        ss.district = this.district;
        ss.subdistrict = this.subdistrict;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.onAddressSelect(ss.code, ss.subdistrict, ss.district, ss.province);
    }

    static class SavedState
    extends View.BaseSavedState {
        String code;
        String subdistrict;
        String district;
        String province;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.code = in.readString();
            this.province = in.readString();
            this.district = in.readString();
            this.subdistrict = in.readString();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.code);
            out.writeString(this.province);
            out.writeString(this.district);
            out.writeString(this.subdistrict);
        }
    }
}

