/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorAdapter;
import android.widget.TextView;
import th.or.nectec.android.library.R;
import th.or.nectec.android.library.widget.TextViewHighLighter;

public class HighLightCursorAdapter
extends CursorAdapter {
    private int mLayout;
    private String[] mFrom;
    private int[] mTo;
    protected String mHighLight;
    protected int mColor;

    public HighLightCursorAdapter(Context context, int layout2, Cursor c, String[] from, int[] to) {
        super(context, c, false);
        this.mLayout = layout2;
        this.mFrom = from;
        this.mTo = to;
        this.mColor = context.getResources().getColor(R.color.holo_blue_light);
    }

    public Cursor swapCursor(Cursor newCursor, String hl) {
        this.mHighLight = hl;
        if (!TextUtils.isEmpty((CharSequence)this.mHighLight)) {
            this.mHighLight = this.mHighLight.toLowerCase();
        }
        return super.swapCursor(newCursor);
    }

    public Cursor swapCursor(Cursor newCursor) {
        this.mHighLight = null;
        return super.swapCursor(newCursor);
    }

    public String getData(int position, int columnIndex) {
        Cursor c = this.getCursor();
        if (c.moveToPosition(position)) {
            return c.getString(columnIndex);
        }
        return null;
    }

    public String getData(int position, String columnName) {
        int columnIndex = this.getCursor().getColumnIndex(columnName);
        return this.getData(position, columnIndex);
    }

    public void bindView(View view, Context context, Cursor c) {
        for (int i = 0; i < this.mFrom.length; ++i) {
            TextView tv = (TextView)view.findViewById(this.mTo[i]);
            if (tv == null) continue;
            String text = c.getString(c.getColumnIndex(this.mFrom[i]));
            TextViewHighLighter.highLight(tv, text, this.mHighLight, this.mColor);
        }
    }

    public View newView(Context context, Cursor c, ViewGroup parent) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View v = inflater.inflate(this.mLayout, parent, false);
        this.bindView(v, context, c);
        return v;
    }
}

