/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.util;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ProgressBar;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONInsertTask
extends AsyncTask<Params, Integer, String> {
    public static final String TAG = "JSONInsertTask";
    Context mContext;
    JSONObject mSQL;
    ProgressBar mProgress;
    OnFinishListener mListener;
    SQLiteOpenHelper mDbHelper;

    public JSONInsertTask(Context context, SQLiteOpenHelper dbHelper, JSONObject sql, ProgressBar progress, OnFinishListener listener) {
        this.mContext = context;
        this.mSQL = sql;
        this.mDbHelper = dbHelper;
        this.mProgress = progress;
        this.mListener = listener;
    }

    protected String doInBackground(Params ... params) {
        int i = 0;
        int lenght = params.length;
        SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
        for (Params p : params) {
            this.createTable(db, this.mSQL, p.uri, p.tablename, p.intColumn, p.strColumn);
            this.publishProgress(new Integer[]{++i * 100 / lenght});
        }
        db.close();
        return null;
    }

    public void createTable(SQLiteDatabase db, JSONObject sql, Uri uri, String tablename, String[] intColumn, String[] strColumn) {
        try {
            JSONArray table = sql.optJSONArray(tablename);
            if (table == null) {
                return;
            }
            int max = table.length();
            db.beginTransaction();
            for (int i = 0; i < max; ++i) {
                JSONObject record = table.getJSONObject(i);
                ContentValues cv = new ContentValues();
                if (intColumn != null) {
                    for (String col : intColumn) {
                        int v = record.optInt(col, -99);
                        if (v == -99) continue;
                        cv.put(col, Integer.valueOf(v));
                    }
                }
                if (strColumn != null) {
                    for (String col : strColumn) {
                        String v = record.optString(col);
                        if (TextUtils.isEmpty((CharSequence)v)) continue;
                        cv.put(col, v);
                    }
                }
                db.insert(tablename, null, cv);
            }
            db.setTransactionSuccessful();
            db.endTransaction();
            this.mContext.getContentResolver().notifyChange(uri, null);
            Log.d((String)TAG, (String)("created table " + tablename));
        }
        catch (JSONException ex) {
            Log.e((String)TAG, (String)("error while createTable " + tablename));
            ex.printStackTrace();
        }
        catch (NullPointerException n) {
            Log.e((String)TAG, (String)("error while createTable " + tablename));
            n.printStackTrace();
        }
    }

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.mProgress != null) {
            this.mProgress.setProgress(values[0].intValue());
        }
    }

    protected void onPostExecute(String result) {
        super.onPostExecute((Object)result);
        if (this.mListener != null) {
            this.mListener.onTaskFinish(result);
        }
    }

    public static interface OnFinishListener {
        public void onTaskFinish(String var1);
    }

    public static class Params {
        public Uri uri;
        public String tablename;
        public String[] intColumn;
        public String[] strColumn;
    }
}

