/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.util;

import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Decompress {
    private String _zipFile;
    private String _location;

    public Decompress(String zipFile, String location) {
        this._zipFile = zipFile;
        this._location = location;
        this._dirChecker("");
    }

    public void unzip() {
        try {
            FileInputStream fin = new FileInputStream(this._zipFile);
            ZipInputStream zin = new ZipInputStream(fin);
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                Log.v((String)"Decompress", (String)("Unzipping " + ze.getName()));
                if (ze.isDirectory()) {
                    this._dirChecker(ze.getName());
                    continue;
                }
                File dest = new File(this._location + ze.getName());
                if (dest.exists()) {
                    dest.delete();
                }
                try {
                    File dir = dest.getParentFile();
                    dir.mkdirs();
                    dest.createNewFile();
                }
                catch (IOException io) {
                    Log.d((String)"Decompress", (String)("dest path=" + dest.getAbsolutePath()));
                    io.printStackTrace();
                }
                FileOutputStream fout = new FileOutputStream(dest);
                int c = zin.read();
                while (c != -1) {
                    fout.write(c);
                    c = zin.read();
                }
                zin.closeEntry();
                fout.close();
            }
            zin.close();
        }
        catch (Exception e) {
            Log.e((String)"Decompress", (String)"unzip", (Throwable)e);
        }
    }

    private void _dirChecker(String dir) {
        File f = new File(this._location + dir);
        if (!f.isDirectory()) {
            f.mkdirs();
        }
    }
}

