/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.smartcard;

import android.text.TextUtils;
import com.idvision.androididcardlib.iCardUsbReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class ThaiCitizenCard {
    private iCardUsbReader reader = null;
    private int lastError = 0;
    private short lastSW = 0;
    private String atrString = null;
    private String appletVersion = null;

    public int getLastError() {
        return this.lastError;
    }

    public String getCardAtrString() {
        return this.atrString;
    }

    public boolean init(iCardUsbReader rdr) {
        this.lastError = -2001;
        this.reader = rdr;
        if (this.reader == null) {
            return false;
        }
        if (!this.reader.getReaderStatus()) {
            return false;
        }
        if (!this.reader.getCardStatus()) {
            return false;
        }
        byte[] atr = new byte[32];
        int len = this.reader.cardConnect(atr);
        if (len == 0) {
            this.lastError = -2002;
            return false;
        }
        this.atrString = "";
        for (int i = 0; i < len; ++i) {
            this.atrString = this.atrString + String.format("%02X ", atr[i]);
        }
        short sw = this.selectApplet();
        if ((sw & 0xFF00) != 24832) {
            this.lastError = -2003;
            return false;
        }
        byte[] buffer = new byte[16];
        if (!this.readBlock((byte)0, 0, 4, buffer)) {
            this.lastError = -2004;
            return false;
        }
        try {
            this.appletVersion = new String(buffer, 0, 4, "TIS620");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.lastError = 0;
        return true;
    }

    public void close() {
        if (this.reader != null) {
            this.reader.cardDisconnect();
        }
    }

    public HolderProfile getHolderProfile() {
        byte[] profile = new byte[400];
        byte[] address = new byte[160];
        boolean loaded = false;
        String cardType = null;
        if (this.appletVersion.equals("0002")) {
            Arrays.fill(address, (byte)32);
            loaded = this.readBlock((byte)1, 0, 377, profile);
            loaded = this.readBlock((byte)0, 4, 150, address);
            cardType = "22";
        }
        if (this.appletVersion.equals("0003")) {
            loaded = this.readBlock((byte)0, 0, 377, profile);
            loaded = this.readBlock((byte)0, 5497, 160, address);
            cardType = "23";
        }
        if (!loaded) {
            return null;
        }
        return new HolderProfile(profile, address);
    }

    public byte[] getHolderPhoto() {
        byte[] buffer = new byte[5120];
        if (this.appletVersion.equals("0002") && this.readBlock((byte)1, 381, 5116, buffer)) {
            return buffer;
        }
        if (this.appletVersion.equals("0003") && this.readBlock((byte)0, 379, 5118, buffer)) {
            return buffer;
        }
        return null;
    }

    private short getResponse(byte[] buffer, int startIndex, int length) {
        byte[] apduResponse = new byte[]{0, -64, 0, 0, 64};
        byte[] res = new byte[512];
        apduResponse[4] = (byte)(length & 0xFF);
        int reslen = this.reader.exchangeAPDU(apduResponse, 5, res);
        if (reslen <= 0) {
            return -1;
        }
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.put(res[reslen - 2]);
        bb.put(res[reslen - 1]);
        short lastSW = bb.getShort(0);
        if (lastSW == -28672) {
            System.arraycopy(res, 0, buffer, startIndex, reslen - 2);
        }
        return lastSW;
    }

    private short selectApplet() {
        byte[] res = new byte[32];
        int reslen = 0;
        byte[] apduSelect = new byte[]{0, -92, 4, 0, 8, -96, 0, 0, 0, 84, 72, 0, 1};
        reslen = this.reader.exchangeAPDU(apduSelect, 13, res);
        if (reslen <= 0) {
            return -1;
        }
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.put(res[0]);
        bb.put(res[1]);
        return bb.getShort(0);
    }

    private short readBinary(byte block, int offset, int length) {
        byte[] res = new byte[512];
        byte[] apduRead = new byte[]{-128, -80, 0, 0, 2, 0, 64};
        apduRead[2] = (byte)(offset >>> 8 & 0xFF);
        apduRead[3] = (byte)(offset & 0xFF);
        apduRead[6] = (byte)(length & 0xFF);
        int reslen = this.reader.exchangeAPDU(apduRead, 7, res);
        if (reslen > 0) {
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.order(ByteOrder.BIG_ENDIAN);
            bb.put(res[0]);
            bb.put(res[1]);
            this.lastSW = bb.getShort(0);
            return this.lastSW;
        }
        return -1;
    }

    private boolean readBlock(byte block, int offset, int length, byte[] buffer) {
        int currentOffset = offset;
        int startIndex = 0;
        while (length > 0) {
            short sw;
            int size = length;
            if (size > 250) {
                size = 250;
            }
            if (((sw = this.readBinary(block, currentOffset, size)) & 0xFF00) != 24832) {
                return false;
            }
            sw = this.getResponse(buffer, startIndex, size);
            if (sw != -28672) {
                return false;
            }
            currentOffset += size;
            startIndex += size;
            length -= size;
        }
        return true;
    }

    public static class HolderProfile {
        byte[] profileByte;
        byte[] addressByte;
        private Address address;
        private Name thaiName;
        private Name engName;
        private String version;
        private String id;
        private String birthday;
        private String sex;
        private String issueDate;
        private String expireDate;
        private String issueLocation;

        public HolderProfile(byte[] profile, byte[] address) {
            this.profileByte = profile;
            this.addressByte = address;
        }

        public Address getAddress() {
            String add = this.bytes2String(this.addressByte, 0, 160);
            this.address = new Address(add.split("\\#"));
            return this.address;
        }

        public Name getThaiName() {
            String text = this.bytes2String(this.profileByte, 17, 100);
            this.thaiName = new Name(text.split("\\#"));
            return this.thaiName;
        }

        public Name getEngName() {
            String text = this.bytes2String(this.profileByte, 117, 100);
            this.engName = new Name(text.split("\\#"));
            return this.engName;
        }

        public String getCardVersion() {
            this.version = this.bytes2String(this.profileByte, 0, 4);
            return this.version;
        }

        public String getId() {
            this.id = this.bytes2String(this.profileByte, 4, 13);
            return this.id;
        }

        public String getBirthday() {
            this.birthday = this.bytes2String(this.profileByte, 217, 8);
            return this.birthday;
        }

        public String getSex() {
            this.sex = this.bytes2String(this.profileByte, 225, 1);
            return this.sex;
        }

        public String getIssueDate() {
            this.issueDate = this.bytes2String(this.profileByte, 359, 8);
            return this.issueDate;
        }

        public String getExpireDate() {
            this.expireDate = this.bytes2String(this.profileByte, 367, 8);
            return this.expireDate;
        }

        public String getIssueLocation() {
            this.issueLocation = this.bytes2String(this.profileByte, 246, 100);
            return this.issueLocation;
        }

        private String bytes2String(byte[] buffer, int startIndex, int length) {
            byte[] bytesInput = new byte[length];
            System.arraycopy(buffer, startIndex, bytesInput, 0, length);
            String textOut = null;
            try {
                textOut = new String(bytesInput, "TIS620");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (textOut != null) {
                textOut = textOut.trim();
            }
            return textOut;
        }

        public class Name {
            private String[] nameArray;

            public Name(String[] name) {
                this.nameArray = name;
            }

            public String getPrename() {
                return this.nameArray[0];
            }

            public String getFirstname() {
                return this.nameArray[1];
            }

            public String getMidname() {
                return this.nameArray[2];
            }

            public String getLastname() {
                return this.nameArray[3];
            }
        }

        public class Address {
            private String[] addressArray;

            public Address(String[] address) {
                this.addressArray = address;
            }

            public String getHouseNumber() {
                return this.addressArray[0].trim();
            }

            public String getTownship() {
                return !TextUtils.isEmpty((CharSequence)this.addressArray[1]) ? this.addressArray[1].substring(7).trim() : "N/A";
            }

            public String getVillage() {
                return !TextUtils.isEmpty((CharSequence)this.addressArray[2]) ? this.addressArray[2].substring(8).trim() : "N/A";
            }

            public String getAlley() {
                return !TextUtils.isEmpty((CharSequence)this.addressArray[3]) ? this.addressArray[3].substring(3).trim() : "N/A";
            }

            public String getRoad() {
                return !TextUtils.isEmpty((CharSequence)this.addressArray[4]) ? this.addressArray[4].substring(3).trim() : "N/A";
            }

            public String getSubdistrict() {
                return !TextUtils.isEmpty((CharSequence)this.addressArray[5]) ? this.addressArray[5].substring(4).trim() : "N/A";
            }

            public String getDistrict() {
                String district = "N/A";
                if (!TextUtils.isEmpty((CharSequence)this.addressArray[6])) {
                    district = this.addressArray[6].contains("\u0e2d\u0e33\u0e40\u0e20\u0e2d") ? this.addressArray[6].substring(5).trim() : this.addressArray[6].substring(3).trim();
                }
                return district;
            }

            public String getProvince() {
                String province = "N/A";
                if (!TextUtils.isEmpty((CharSequence)this.addressArray[7])) {
                    province = this.addressArray[7].contains("\u0e08\u0e31\u0e07\u0e2b\u0e27\u0e31\u0e14") ? this.addressArray[7].substring(7).trim() : this.addressArray[7].trim();
                }
                return province;
            }

            public String toString() {
                String a = "";
                for (String s : this.addressArray) {
                    a = a + s + ":";
                }
                return a;
            }
        }
    }
}

