/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.network;

import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HttpUploader
extends AsyncTask<UploadParams, String, Integer> {
    public static final String TAG = "uploader";
    String uploadedUrl;
    String uploadedPath;
    UploadProcessCallback callback;

    protected Integer doInBackground(UploadParams ... params) {
        int successCount = 0;
        for (UploadParams p : params) {
            String statusString = "fail";
            Object response = null;
            ServerResponse res = HttpUploader.upload(p.url, p.filePath, p.params);
            if (res.code == 200) {
                statusString = "success";
                ++successCount;
            }
            this.publishProgress(new String[]{statusString, p.url, p.filePath, res.message});
            if (this.isCancelled()) break;
        }
        return successCount;
    }

    public static ServerResponse upload(String dest, String path, Map<String, String> reqParams) {
        ServerResponse res = new ServerResponse();
        URLConnection connection = null;
        DataOutputStream outputStream = null;
        int serverResponseCode = 0;
        StringBuilder bodyBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = reqParams.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> params = iterator.next();
            bodyBuilder.append(params.getKey()).append('=').append(params.getValue());
            if (!iterator.hasNext()) continue;
            bodyBuilder.append('&');
        }
        String body = bodyBuilder.toString();
        String pathToOurFile = path;
        String urlServer = dest;
        if (body.length() > 0) {
            urlServer = dest + "?" + body;
        }
        String lineEnd = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        int maxBufferSize = 0x100000;
        File sourceFile = new File(pathToOurFile);
        if (!sourceFile.isFile()) {
            Log.e((String)TAG, (String)"Source File Does not exist");
            res.code = 404;
            res.message = "Source File Does not exist";
            return res;
        }
        Object message = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(pathToOurFile));
            URL url = new URL(urlServer);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            ((HttpURLConnection)connection).setChunkedStreamingMode(0);
            ((HttpURLConnection)connection).setRequestMethod("POST");
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            outputStream = new DataOutputStream(connection.getOutputStream());
            outputStream.writeBytes(twoHyphens + boundary + lineEnd);
            outputStream.writeBytes("Content-Disposition: form-data; name=\"uploadedfile\";filename=\"" + pathToOurFile + "\"" + lineEnd);
            outputStream.writeBytes(lineEnd);
            int bytesAvailable = fileInputStream.available();
            int bufferSize = Math.min(bytesAvailable, maxBufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            while (bytesRead > 0) {
                outputStream.write(buffer, 0, bufferSize);
                bytesAvailable = fileInputStream.available();
                bufferSize = Math.min(bytesAvailable, maxBufferSize);
                bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            }
            outputStream.writeBytes(lineEnd);
            outputStream.writeBytes(twoHyphens + boundary + twoHyphens + lineEnd);
            serverResponseCode = ((HttpURLConnection)connection).getResponseCode();
            String serverResponseMessage = ((HttpURLConnection)connection).getResponseMessage();
            res.code = serverResponseCode;
            Log.d((String)TAG, (String)("ServerResponse code=" + serverResponseCode + " msg=" + serverResponseMessage));
            fileInputStream.close();
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
        }
        try {
            String line;
            BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = rd.readLine()) != null) {
                if (TextUtils.isEmpty((CharSequence)(line = line.trim()))) continue;
                res.message = !TextUtils.isEmpty((CharSequence)res.message) ? res.message + line : line;
                Log.i((String)TAG, (String)("RES Message: " + line));
            }
            rd.close();
        }
        catch (IOException ioex) {
            Log.e((String)TAG, (String)("error: " + ioex.getMessage()), (Throwable)ioex);
        }
        return res;
    }

    protected void onProgressUpdate(String ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.callback != null) {
            boolean status = values[0].equals("success");
            this.callback.onProgressUpdate(status, values[1], values[2], values[3]);
        }
    }

    protected void onPostExecute(Integer result) {
        super.onPostExecute((Object)result);
        if (this.callback != null) {
            this.callback.onProcessFinish(result);
        }
    }

    public void setProcessCallback(UploadProcessCallback callback) {
        this.callback = callback;
    }

    public static interface UploadProcessCallback {
        public void onProgressUpdate(boolean var1, String var2, String var3, String var4);

        public void onProcessFinish(int var1);
    }

    static class ServerResponse {
        int code = 0;
        String message = null;
    }

    public static class UploadParams {
        protected String url = null;
        protected String filePath = null;
        public Map<String, String> params;

        public UploadParams(String url, String path) {
            this.url = url;
            this.filePath = path;
            this.params = new HashMap<String, String>();
        }

        public void putParam(String key, String value) {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            this.params.put(key, value);
        }
    }
}

