/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.form.validator;

import android.text.TextUtils;
import th.or.nectec.android.library.form.validator.AbstractValidator;
import th.or.nectec.android.library.form.validator.ValidatorException;

public class NumbericIntervalValidator
extends AbstractValidator {
    public static final int OPEN_INTERVAL = 0;
    public static final int CLOSE_INTERVAL = 1;
    int mCompareMode;
    Double mStartRange;
    Double mEndRange;

    public NumbericIntervalValidator(int mode, Double startRange, Double endRange) {
        super(null);
        this.mCompareMode = mode;
        this.mStartRange = startRange;
        this.mEndRange = endRange;
    }

    public NumbericIntervalValidator(int mode, Double startRange, Double endRange, String errorMessage) {
        super(null);
        this.mCompareMode = mode;
        this.mStartRange = startRange;
        this.mEndRange = endRange;
        this.mErrorMsg = errorMessage;
    }

    public NumbericIntervalValidator(int mode, int startRange, int endRange, String errorMessage) {
        super(null);
        this.mCompareMode = mode;
        this.mStartRange = startRange;
        this.mEndRange = endRange;
        this.mErrorMsg = errorMessage;
    }

    @Override
    public boolean isValid(String value) throws ValidatorException {
        double val = Double.valueOf(value);
        switch (this.mCompareMode) {
            case 0: {
                return this.mStartRange < val && val < this.mEndRange;
            }
            case 1: {
                return this.mStartRange <= val && val <= this.mEndRange;
            }
        }
        return true;
    }

    @Override
    public String getMessage() {
        if (!TextUtils.isEmpty((CharSequence)this.mErrorMsg)) {
            return this.mErrorMsg;
        }
        switch (this.mCompareMode) {
            case 1: {
                return "\u0e04\u0e48\u0e32\u0e19\u0e35\u0e49\u0e15\u0e49\u0e2d\u0e07\u0e2d\u0e22\u0e39\u0e48\u0e23\u0e30\u0e2b\u0e27\u0e48\u0e32\u0e07 " + this.mStartRange + " \u0e16\u0e36\u0e07 " + this.mEndRange;
            }
            case 0: {
                return "\u0e04\u0e48\u0e32\u0e19\u0e35\u0e49\u0e15\u0e49\u0e2d\u0e07\u0e21\u0e35\u0e04\u0e48\u0e32\u0e15\u0e31\u0e49\u0e07\u0e41\u0e15\u0e48 " + this.mStartRange + " \u0e16\u0e36\u0e07 " + this.mEndRange;
            }
        }
        return "\u0e44\u0e21\u0e48\u0e17\u0e23\u0e32\u0e1a";
    }

    public static NumbericIntervalValidator getMinimunValidator(int mode, double minValue) {
        return new NumbericIntervalValidator(mode, minValue, (Double)Double.MAX_VALUE);
    }
}

