/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.form;

import android.app.Activity;
import android.app.LoaderManager;
import android.content.ContentValues;
import android.content.Context;
import android.content.CursorLoader;
import android.content.Loader;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import th.or.nectec.android.library.R;
import th.or.nectec.android.library.form.IMultiColumnField;
import th.or.nectec.android.library.form.NTField;
import th.or.nectec.android.library.form.field.NTAddressField;
import th.or.nectec.android.library.form.field.NTArrayFormatSpinnerField;
import th.or.nectec.android.library.form.field.NTAutoCompleteTextField;
import th.or.nectec.android.library.form.field.NTCheckBoxField;
import th.or.nectec.android.library.form.field.NTCheckListField;
import th.or.nectec.android.library.form.field.NTDateField;
import th.or.nectec.android.library.form.field.NTLandAreaField;
import th.or.nectec.android.library.form.field.NTMultiChoiceField;
import th.or.nectec.android.library.form.field.NTNumberField;
import th.or.nectec.android.library.form.field.NTSingleChoiceField;
import th.or.nectec.android.library.form.field.NTTextField;
import th.or.nectec.android.library.form.generate.Field;
import th.or.nectec.android.library.form.generate.Value;
import th.or.nectec.android.library.widget.ArrayFormatSpinner;
import th.or.nectec.android.library.widget.LandAreaEditText;
import th.or.nectec.android.library.widget.ThaiDatePicker;
import th.or.nectec.android.library.widget.address.AddressView;

public class NTForm
implements LoaderManager.LoaderCallbacks<Cursor> {
    private static final int RESTORE_DATA = 112;
    private static final int RESTORE_EAV_DATA = 113;
    Activity mActivity;
    View mView;
    ArrayList<NTField> mFieldList = new ArrayList();
    private String mErrMessage;
    private String[] mExtraColumn;
    String mEavAttribute;
    String mEavValue;
    RestoreDataListener mRestoreListner;

    public NTForm(Activity activity) {
        this.mActivity = activity;
        this.mView = activity.getWindow().getDecorView().findViewById(0x1020002);
    }

    public NTForm(Activity activity, View view) {
        this.mActivity = activity;
        this.mView = view;
    }

    public NTField addField(NTField field) {
        this.mFieldList.add(field);
        field.onAddToForm(this);
        return field;
    }

    public NTTextField addTextField(int id2, String column) {
        TextView v = (TextView)this.mView.findViewById(id2);
        NTTextField field = new NTTextField(v, column);
        this.addField(field);
        return field;
    }

    public NTDateField addDateField(int id2, String column) {
        ThaiDatePicker v = (ThaiDatePicker)this.mView.findViewById(id2);
        v.updateDate();
        NTDateField field = new NTDateField(v, column);
        this.addField(field);
        return field;
    }

    public NTArrayFormatSpinnerField addArrayFormatField(int id2, String column, int arrayId) {
        ArrayFormatSpinner v = (ArrayFormatSpinner)this.mView.findViewById(id2);
        v.setArray(arrayId);
        NTArrayFormatSpinnerField field = new NTArrayFormatSpinnerField(v, column);
        this.addField(field);
        return field;
    }

    public NTAddressField addAddressField(int id2, String addressCode, String subdistrict, String district, String province) {
        AddressView address = (AddressView)this.mView.findViewById(id2);
        NTAddressField field = new NTAddressField(address, addressCode, subdistrict, district, province);
        this.addField(field);
        return field;
    }

    public NTLandAreaField addLandAreaField(int id2, String column) {
        LandAreaEditText v = (LandAreaEditText)this.mView.findViewById(id2);
        NTLandAreaField field = new NTLandAreaField(v, column);
        this.addField(field);
        return field;
    }

    public void addExtraRestoreColumn(String ... columns) {
        this.mExtraColumn = columns;
    }

    public void restoreData(Uri contentUri, String where, String[] whereArgs, RestoreDataListener listener) {
        Bundle args = new Bundle();
        args.putString("uri", contentUri.toString());
        args.putString("where", where);
        args.putStringArray("whereArgs", whereArgs);
        this.mRestoreListner = listener;
        this.mActivity.getLoaderManager().restartLoader(112, args, (LoaderManager.LoaderCallbacks)this);
    }

    public void restoreData(Uri contentUri, String where, String[] whereArgs) {
        this.restoreData(contentUri, where, whereArgs, null);
    }

    public void restoreEAVData(Uri contentUri, String attribute, String value, String where, String[] whereArgs) {
        this.mEavAttribute = attribute;
        this.mEavValue = value;
        Bundle args = new Bundle();
        args.putString("uri", contentUri.toString());
        args.putString("where", where);
        args.putStringArray("whereArgs", whereArgs);
        this.mActivity.getLoaderManager().restartLoader(113, args, (LoaderManager.LoaderCallbacks)this);
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        Uri uri = Uri.parse((String)args.getString("uri"));
        String where = args.getString("where");
        String[] whereArgs = args.getStringArray("whereArgs");
        CursorLoader cl = null;
        switch (id2) {
            case 112: {
                cl = new CursorLoader((Context)this.mActivity, uri, this.getProjection(), where, whereArgs, null);
                break;
            }
            case 113: {
                cl = new CursorLoader((Context)this.mActivity, uri, new String[]{this.mEavAttribute, this.mEavValue}, where, whereArgs, null);
            }
        }
        return cl;
    }

    private String[] getProjection() {
        ArrayList<String> proj = new ArrayList<String>();
        int fieldCount = this.mFieldList.size();
        for (int i = 0; i < fieldCount; ++i) {
            NTField field = this.mFieldList.get(i);
            if (!field.isMultiColumn()) {
                proj.add(field.getColumn());
                continue;
            }
            String[] cols = ((IMultiColumnField)((Object)field)).getColumns();
            int colCount = cols.length;
            for (int j = 0; j < colCount; ++j) {
                proj.add(cols[j]);
            }
        }
        if (this.mExtraColumn != null) {
            int extraColumnCount = this.mExtraColumn.length;
            for (int i = 0; i < extraColumnCount; ++i) {
                proj.add(this.mExtraColumn[i]);
            }
        }
        return proj.toArray(new String[proj.size()]);
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public NTField getFieldByColumn(String columns) {
        int fieldCount = this.mFieldList.size();
        for (int i = 0; i < fieldCount; ++i) {
            NTField field = this.mFieldList.get(i);
            if (!columns.equalsIgnoreCase(field.getColumn())) continue;
            return field;
        }
        return null;
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor c) {
        if (!c.moveToFirst()) {
            if (this.mRestoreListner != null) {
                this.mRestoreListner.onRestoreDataNotFound();
            }
            return;
        }
        switch (loader.getId()) {
            case 112: {
                int fieldCount = this.mFieldList.size();
                for (int i = 0; i < fieldCount; ++i) {
                    NTField field = this.mFieldList.get(i);
                    if (!field.isMultiColumn()) {
                        String value = c.getString(c.getColumnIndex(field.getColumn()));
                        if (TextUtils.isEmpty((CharSequence)value)) continue;
                        field.setValue(value);
                        continue;
                    }
                    IMultiColumnField mfield = (IMultiColumnField)((Object)field);
                    mfield.setValueByCursor(c);
                }
                break;
            }
            case 113: {
                Log.d((String)"NTForm", (String)"not move to first");
                do {
                    String attribute = c.getString(0);
                    String value = c.getString(1);
                    Log.d((String)"NTForm", (String)("attr=" + attribute + " value=" + value));
                    NTField field = this.getFieldByColumn(attribute);
                    if (field == null || TextUtils.isEmpty((CharSequence)value)) continue;
                    field.setValue(value);
                } while (c.moveToNext());
            }
        }
        if (this.mRestoreListner != null) {
            this.mRestoreListner.onRestored(c);
        }
    }

    public void onLoaderReset(Loader<Cursor> arg0) {
    }

    public void setEnabled(boolean enabled) {
        int fieldCount = this.mFieldList.size();
        for (int i = 0; i < fieldCount; ++i) {
            this.mFieldList.get(i).setEnabled(enabled);
        }
    }

    public boolean validate() {
        int invalid = 0;
        this.mErrMessage = null;
        boolean focused = false;
        int fieldCount = this.mFieldList.size();
        for (int i = 0; i < fieldCount; ++i) {
            NTField field = this.mFieldList.get(i);
            if (field.isValid()) continue;
            ++invalid;
            if (focused) continue;
            this.mErrMessage = field.getMessages();
            field.getView().requestFocus();
            focused = true;
        }
        return invalid <= 0;
    }

    public ContentValues buildContentValue() {
        ContentValues cv = new ContentValues();
        int fieldCount = this.mFieldList.size();
        for (int i = 0; i < fieldCount; ++i) {
            NTField field = this.mFieldList.get(i);
            if (!field.isMultiColumn()) {
                cv.put(field.getColumn(), field.getValue());
                continue;
            }
            ContentValues v = ((IMultiColumnField)((Object)field)).getContentValues();
            cv.putAll(v);
        }
        return cv;
    }

    public ContentValues[] buildEAVContentValue(String attributeColumnName, String valueColumnsName) {
        int fieldCount = this.mFieldList.size();
        ContentValues[] cvs = new ContentValues[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            ContentValues cv = new ContentValues();
            NTField field = this.mFieldList.get(i);
            cv.put(attributeColumnName, field.getColumn());
            cv.put(valueColumnsName, field.getValue());
            cvs[i] = cv;
        }
        return cvs;
    }

    public ArrayList<NTField> getFields() {
        return this.mFieldList;
    }

    public void Log() {
        Log.d((String)"NTForm", (String)this.toString());
        int fieldCount = this.mFieldList.size();
        for (int i = 0; i < fieldCount; ++i) {
            NTField field = this.mFieldList.get(i);
            Log.d((String)"NTForm", (String)field.toString());
        }
    }

    public String getErrorMessage() {
        return this.mErrMessage;
    }

    public void buildForm() {
        if (!(this.mView instanceof ViewGroup)) {
            throw new IllegalArgumentException("Have no ViewGroup Can't build form");
        }
        this.buildForm((ViewGroup)this.mView);
    }

    public void buildForm(ViewGroup parent) {
        if (parent == null) {
            throw new NullPointerException("Build Form container must not be Null. please check buildForm() input");
        }
        int fieldCount = this.mFieldList.size();
        for (int i = 0; i < fieldCount; ++i) {
            boolean isLast = i == fieldCount - 1;
            boolean isNextQuestionNoTitle = !isLast && TextUtils.isEmpty((CharSequence)this.mFieldList.get(i + 1).getLabel());
            NTField field = this.mFieldList.get(i);
            field.buildForm((Context)this.mActivity, parent, isLast, isNextQuestionNoTitle);
        }
    }

    public String toString() {
        return "NTForm [mFieldList=" + this.mFieldList.size() + ", getProjection()=" + Arrays.toString(this.getProjection()) + "]";
    }

    public static class Builder {
        public static final String TAG = "Form-Builder";
        public static final int TYPE_TEXT = 1;
        public static final int TYPE_INTEGER = 2;
        public static final int TYPE_DECIMAL = 3;
        public static final int TYPE_MULTICHOICE = 4;
        public static final int TYPE_SINGLECHOICE = 5;
        public static final int TYPE_ADDRESS = 6;
        public static final int TYPE_DATE = 7;
        public static final int TYPE_CHECKLIST = 8;
        public static final int TYPE_AUTOCOMPLETE = 9;
        public static final int TYPE_CHECKBOX = 10;
        public static HashMap<String, Integer> mFieldTypeMap = new HashMap();
        Activity mActivity;
        TextView mNotFoundTxt;
        public static String[] REQUIRE_COLUMN;
        Field[] mField;

        public Builder(Activity activity, Cursor c) {
            this.mActivity = activity;
            this.setCursor(c);
            this.mNotFoundTxt = new TextView((Context)activity);
        }

        public Builder setCursor(Cursor c) {
            int count = c.getCount();
            if (count == 0) {
                return null;
            }
            this.mField = new Field[count];
            for (int i = 0; i < count; ++i) {
                c.moveToPosition(i);
                this.mField[i] = Field.createByCursor(c);
            }
            return this;
        }

        public NTForm build(ViewGroup parent) {
            if (parent == null) {
                throw new IllegalArgumentException("parent view is null");
            }
            if (this.mField.length == 0) {
                parent.addView((View)this.mNotFoundTxt);
            }
            NTForm form = new NTForm(this.mActivity);
            for (int i = 0; i < this.mField.length; ++i) {
                Field f = this.mField[i];
                NTField ntField = null;
                switch (mFieldTypeMap.get(f.getType())) {
                    case 1: {
                        NTTextField txt = new NTTextField(f.getColumnName(), f.getLabel());
                        ntField = txt;
                        break;
                    }
                    case 2: {
                        NTNumberField integer = new NTNumberField(f.getColumnName(), f.getLabel());
                        integer.setNumberInputType(0);
                        ntField = integer;
                        break;
                    }
                    case 3: {
                        NTNumberField decimal = new NTNumberField(f.getColumnName(), f.getLabel());
                        decimal.setNumberInputType(1);
                        ntField = decimal;
                        break;
                    }
                    case 4: {
                        NTMultiChoiceField mc = new NTMultiChoiceField(f.getColumnsName(), f.getLabel(), Value.toString(f.getValues()));
                        ntField = mc;
                        break;
                    }
                    case 8: {
                        NTCheckListField cl = new NTCheckListField(f.getColumnsName(), f.getLabel(), Value.toString(f.getValues()));
                        ntField = cl;
                        break;
                    }
                    case 7: {
                        NTDateField dt = new NTDateField(f.getColumnName(), f.getLabel());
                        ntField = dt;
                        break;
                    }
                    case 6: {
                        NTAddressField ad = !TextUtils.isEmpty((CharSequence)f.getColumnName()) ? new NTAddressField(f.getColumnName(), f.getLabel()) : new NTAddressField(f.getLabel());
                        ntField = ad;
                        break;
                    }
                    case 5: {
                        NTSingleChoiceField sc = new NTSingleChoiceField(f.getColumnName(), f.getLabel(), Value.toString(f.getValues()));
                        ntField = sc;
                        break;
                    }
                    case 9: {
                        NTAutoCompleteTextField at = new NTAutoCompleteTextField(f.getColumnName(), f.getLabel());
                        Object[] suggest = new String[f.getValues().length];
                        for (int valueIndex = 0; valueIndex < f.getValues().length; ++valueIndex) {
                            suggest[valueIndex] = f.getValues()[valueIndex].getLabel();
                            Log.d((String)"ttt", (String)("suggest=" + (String)suggest[valueIndex]));
                        }
                        ArrayAdapter adapter = new ArrayAdapter((Context)this.mActivity, R.layout.default_spinner_item, suggest);
                        at.setAdapter((ArrayAdapter<String>)adapter);
                        ntField = at;
                        break;
                    }
                    case 10: {
                        NTCheckBoxField cb = new NTCheckBoxField(f.getColumnName(), f.getLabel(), Value.toString(f.getValues()));
                        ntField = cb;
                    }
                }
                ntField.setFieldOption(f.getOption());
                if (f.isMandatory().booleanValue()) {
                    Log.d((String)"NTForm", (String)("mandatory=" + f.isMandatory()));
                    ntField.setMandatory((Context)this.mActivity);
                }
                form.addField(ntField);
            }
            form.buildForm(parent);
            return form;
        }

        public NTForm build() {
            View v = this.mActivity.getWindow().getDecorView().findViewById(0x1020002);
            if (v instanceof ViewGroup) {
                ViewGroup parent = (ViewGroup)v;
                return this.build(parent);
            }
            Toast.makeText((Context)this.mActivity, (CharSequence)"can't build form", (int)0).show();
            return null;
        }

        static {
            mFieldTypeMap.put("text", 1);
            mFieldTypeMap.put("integer", 2);
            mFieldTypeMap.put("decimal", 3);
            mFieldTypeMap.put("multi-choice", 4);
            mFieldTypeMap.put("checklist", 8);
            mFieldTypeMap.put("checkbox", 10);
            mFieldTypeMap.put("single-choice", 5);
            mFieldTypeMap.put("address", 6);
            mFieldTypeMap.put("date", 7);
            mFieldTypeMap.put("autocomplete", 9);
            REQUIRE_COLUMN = new String[]{"column", "columns", "label", "mandatory", "type", "validator", "value", "option"};
        }
    }

    public static interface RestoreDataListener {
        public void onRestored(Cursor var1);

        public void onRestoreDataNotFound();
    }
}

