/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.activity;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.PagerTabStrip;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.TabHost;
import android.widget.TabWidget;
import java.util.ArrayList;
import th.or.nectec.android.library.R;

public class NTTabPagerActivity
extends Activity {
    TabHost mTabHost;
    TabWidget mTabWidget;
    ViewPager mViewPager;
    PagerTabStrip mTabStrip;
    TabsPagerAdapter mTabsAdapter;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.default_tabs_pager_activity);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.getTabHost().setCurrentTabByTag(savedInstanceState.getString("tab"));
        }
    }

    public TabHost getTabHost() {
        if (this.mTabHost != null) {
            return this.mTabHost;
        }
        this.mTabHost = (TabHost)this.findViewById(0x1020012);
        this.mTabHost.setup();
        return this.mTabHost;
    }

    public ViewPager getViewPager() {
        if (this.mViewPager != null) {
            return this.mViewPager;
        }
        this.mViewPager = (ViewPager)this.findViewById(R.id.pager);
        return this.mViewPager;
    }

    public void setShowPagerTitleStrip(boolean show) {
        int visible;
        int n = visible = show ? 0 : 8;
        if (this.mTabStrip == null) {
            this.mTabStrip = (PagerTabStrip)this.findViewById(R.id.title);
        }
        this.mTabStrip.setVisibility(visible);
    }

    public void setShowTabWidget(boolean show) {
        int visible;
        int n = visible = show ? 0 : 8;
        if (this.mTabWidget == null) {
            this.mTabWidget = (TabWidget)this.findViewById(16908307);
        }
        this.mTabWidget.setVisibility(visible);
    }

    public void setTabsPagerAdapter(TabsPagerAdapter adapter) {
        this.mTabsAdapter = adapter;
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("tab", this.mTabHost.getCurrentTabTag());
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mTabHost = null;
        this.mViewPager = null;
        if (this.mTabsAdapter != null) {
            this.mTabsAdapter.close();
        }
        this.mTabsAdapter = null;
    }

    public static class TabsPagerAdapter
    extends FragmentPagerAdapter
    implements TabHost.OnTabChangeListener,
    ViewPager.OnPageChangeListener {
        private Context mContext;
        private TabHost mTabHost;
        private ViewPager mViewPager;
        private ArrayList<TabInfo> mTabs = new ArrayList();
        private ViewPager.OnPageChangeListener mListener;

        public void setOnPagerChangeListener(ViewPager.OnPageChangeListener listener) {
            this.mListener = listener;
        }

        public TabsPagerAdapter(FragmentActivity activity, TabHost tabHost, ViewPager pager) {
            super(activity.getSupportFragmentManager());
            this.mContext = activity;
            this.mTabHost = tabHost;
            this.mViewPager = pager;
            this.mTabHost.setOnTabChangedListener((TabHost.OnTabChangeListener)this);
            this.mViewPager.setAdapter((PagerAdapter)this);
            this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }

        public void addTab(TabHost.TabSpec tabSpec, Class<?> clss, Bundle args) {
            tabSpec.setContent((TabHost.TabContentFactory)new DummyTabFactory(this.mContext));
            String tag = tabSpec.getTag();
            TabInfo info = new TabInfo(tag, clss, args);
            this.mTabs.add(info);
            this.mTabHost.addTab(tabSpec);
            this.notifyDataSetChanged();
            TabWidget tabWidget = this.mTabHost.getTabWidget();
            int tabCount = tabWidget.getChildCount();
            if (tabCount > 0) {
                View tab = tabWidget.getChildAt(tabCount - 1);
            }
        }

        public void addTab(String tag, Class<?> clss, Bundle args) {
            this.addTab(this.mTabHost.newTabSpec(tag).setIndicator((CharSequence)tag), clss, args);
        }

        public void addTab(String tag, Drawable icon, Class<?> clss, Bundle args) {
            this.addTab(this.mTabHost.newTabSpec(tag).setIndicator((CharSequence)tag, icon), clss, args);
        }

        public int getCount() {
            if (this.mTabs != null) {
                return this.mTabs.size();
            }
            return 0;
        }

        public Fragment getItem(int position) {
            TabInfo info = this.mTabs.get(position);
            return Fragment.instantiate((Context)this.mContext, (String)info.clss.getName(), (Bundle)info.args);
        }

        public CharSequence getPageTitle(int position) {
            TabInfo info = this.mTabs.get(position);
            return info.tag;
        }

        public void onTabChanged(String tabId) {
            int position = this.mTabHost.getCurrentTab();
            this.mViewPager.setCurrentItem(position);
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (this.mListener != null) {
                this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageSelected(int position) {
            TabWidget widget = this.mTabHost.getTabWidget();
            int oldFocusability = widget.getDescendantFocusability();
            widget.setDescendantFocusability(393216);
            this.mTabHost.setCurrentTab(position);
            widget.setDescendantFocusability(oldFocusability);
            if (this.mListener != null) {
                this.mListener.onPageSelected(position);
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (this.mListener != null) {
                this.mListener.onPageScrollStateChanged(state);
            }
        }

        public void close() {
            this.mContext = null;
            this.mTabHost = null;
            this.mViewPager = null;
            this.mListener = null;
            this.mTabs = null;
        }

        static class DummyTabFactory
        implements TabHost.TabContentFactory {
            private final Context mContext;

            public DummyTabFactory(Context context) {
                this.mContext = context;
            }

            public View createTabContent(String tag) {
                View v = new View(this.mContext);
                v.setMinimumWidth(0);
                v.setMinimumHeight(0);
                return v;
            }
        }

        static final class TabInfo {
            protected final String tag;
            protected final Class<?> clss;
            protected final Bundle args;

            TabInfo(String _tag, Class<?> _class, Bundle _args) {
                this.tag = _tag;
                this.clss = _class;
                this.args = _args;
            }
        }
    }
}

