/*
 * Decompiled with CFR 0.152.
 */
package com.idvision.androididcardlib;

import com.idvision.androididcardlib.iCardUsbReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class NIDSmartCard {
    private iCardUsbReader reader = null;
    private int lastError = 0;
    private short lastSW = 0;
    private String atrString = null;
    private String appletVersion = null;

    public int getLastError() {
        return this.lastError;
    }

    public String getCardAtrString() {
        return this.atrString;
    }

    public boolean init(iCardUsbReader rdr) {
        this.lastError = -2001;
        this.reader = rdr;
        if (this.reader == null) {
            return false;
        }
        if (!this.reader.getReaderStatus()) {
            return false;
        }
        if (!this.reader.getCardStatus()) {
            return false;
        }
        byte[] atr = new byte[32];
        int len = this.reader.cardConnect(atr);
        if (len == 0) {
            this.lastError = -2002;
            return false;
        }
        this.atrString = "";
        int i = 0;
        while (i < len) {
            this.atrString = String.valueOf(this.atrString) + String.format("%02X ", atr[i]);
            ++i;
        }
        short sw = this.selectApplet();
        if ((sw & 0xFF00) != 24832) {
            this.lastError = -2003;
            return false;
        }
        byte[] buffer = new byte[16];
        if (!this.readBlock((byte)0, 0, 4, buffer)) {
            this.lastError = -2004;
            return false;
        }
        try {
            this.appletVersion = new String(buffer, 0, 4, "TIS620");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.lastError = 0;
        return true;
    }

    public void close() {
        if (this.reader != null) {
            this.reader.cardDisconnect();
        }
    }

    public String getHolderProfile() {
        byte[] profile = new byte[400];
        byte[] address = new byte[160];
        boolean loaded = false;
        String cardType = null;
        if (this.appletVersion.equals("0002")) {
            Arrays.fill(address, (byte)32);
            loaded = this.readBlock((byte)1, 0, 377, profile);
            loaded = this.readBlock((byte)0, 4, 150, address);
            cardType = "22";
        }
        if (this.appletVersion.equals("0003")) {
            loaded = this.readBlock((byte)0, 0, 377, profile);
            loaded = this.readBlock((byte)0, 5497, 160, address);
            cardType = "23";
        }
        if (!loaded) {
            return null;
        }
        String csvText = String.valueOf(cardType) + "|";
        csvText = String.valueOf(csvText) + this.bytes2String(profile, 4, 13) + "|";
        String text = this.bytes2String(profile, 17, 100);
        text = text.replace('#', '|');
        csvText = String.valueOf(csvText) + text;
        text = this.bytes2String(profile, 117, 100);
        text = text.replace('#', '|');
        csvText = String.valueOf(csvText) + text;
        text = this.bytes2String(profile, 217, 9);
        csvText = String.valueOf(csvText) + text.substring(0, 7) + "|";
        csvText = String.valueOf(csvText) + text.substring(8, 8) + "|";
        text = this.bytes2String(profile, 246, 100);
        csvText = String.valueOf(csvText) + text + "|";
        text = this.bytes2String(profile, 359, 16);
        csvText = String.valueOf(csvText) + text.substring(0, 7) + "|";
        csvText = String.valueOf(csvText) + text.substring(8, 15) + "|";
        text = this.bytes2String(address, 0, 160);
        text = text.replace('#', '|');
        if (this.appletVersion.equals("0002")) {
            StringBuilder sb = new StringBuilder(text);
            int i = 0;
            int count = 0;
            i = 0;
            while (i < sb.length()) {
                if (sb.charAt(i) == '|') {
                    ++count;
                }
                if (count == 1) break;
                ++i;
            }
            sb = sb.insert(i, '|');
            text = sb.toString();
        }
        csvText = String.valueOf(csvText) + text;
        return csvText;
    }

    public byte[] getHolderPhoto() {
        byte[] buffer = new byte[5120];
        if (this.appletVersion.equals("0002") && this.readBlock((byte)1, 381, 5116, buffer)) {
            return buffer;
        }
        if (this.appletVersion.equals("0003") && this.readBlock((byte)0, 379, 5118, buffer)) {
            return buffer;
        }
        return null;
    }

    private String bytes2String(byte[] buffer, int startIndex, int length) {
        byte[] bytesInput = new byte[length];
        System.arraycopy(buffer, startIndex, bytesInput, 0, length);
        String textOut = null;
        try {
            textOut = new String(bytesInput, "TIS620");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (textOut != null) {
            textOut = textOut.trim();
        }
        return textOut;
    }

    private short getResponse(byte[] buffer, int startIndex, int length) {
        byte[] byArray = new byte[5];
        byArray[1] = -64;
        byArray[4] = 64;
        byte[] apduResponse = byArray;
        byte[] res = new byte[512];
        apduResponse[4] = (byte)(length & 0xFF);
        int reslen = this.reader.exchangeAPDU(apduResponse, 5, res);
        if (reslen <= 0) {
            return -1;
        }
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.put(res[reslen - 2]);
        bb.put(res[reslen - 1]);
        short lastSW = bb.getShort(0);
        if (lastSW == -28672) {
            System.arraycopy(res, 0, buffer, startIndex, reslen - 2);
        }
        return lastSW;
    }

    private short selectApplet() {
        byte[] res = new byte[32];
        int reslen = 0;
        byte[] byArray = new byte[13];
        byArray[1] = -92;
        byArray[2] = 4;
        byArray[4] = 8;
        byArray[5] = -96;
        byArray[9] = 84;
        byArray[10] = 72;
        byArray[12] = 1;
        byte[] apduSelect = byArray;
        reslen = this.reader.exchangeAPDU(apduSelect, 13, res);
        if (reslen <= 0) {
            return -1;
        }
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.put(res[0]);
        bb.put(res[1]);
        return bb.getShort(0);
    }

    private short readBinary(byte block, int offset, int length) {
        byte[] res = new byte[512];
        byte[] byArray = new byte[7];
        byArray[0] = -128;
        byArray[1] = -80;
        byArray[4] = 2;
        byArray[6] = 64;
        byte[] apduRead = byArray;
        apduRead[2] = (byte)(offset >>> 8 & 0xFF);
        apduRead[3] = (byte)(offset & 0xFF);
        apduRead[6] = (byte)(length & 0xFF);
        int reslen = this.reader.exchangeAPDU(apduRead, 7, res);
        if (reslen > 0) {
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.order(ByteOrder.BIG_ENDIAN);
            bb.put(res[0]);
            bb.put(res[1]);
            this.lastSW = bb.getShort(0);
            return this.lastSW;
        }
        return -1;
    }

    private boolean readBlock(byte block, int offset, int length, byte[] buffer) {
        int currentOffset = offset;
        int startIndex = 0;
        while (length > 0) {
            short sw;
            int size = length;
            if (size > 250) {
                size = 250;
            }
            if (((sw = this.readBinary(block, currentOffset, size)) & 0xFF00) != 24832) {
                return false;
            }
            sw = this.getResponse(buffer, startIndex, size);
            if (sw != -28672) {
                return false;
            }
            currentOffset += size;
            startIndex += size;
            length -= size;
        }
        return true;
    }
}

