/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins;

import com.google.inject.Inject;
import com.testdroid.jenkins.RunInCloudBuilder;
import com.testdroid.jenkins.WaitForResultsBlock;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PipelineCloudStep
extends AbstractStepImpl {
    private static final Logger LOGGER = Logger.getLogger(PipelineCloudStep.class.getSimpleName());
    private String appPath;
    private String deviceGroupId;
    private String dataPath;
    private String testPath;
    private boolean failBuildIfThisStepFailed;
    private String keyValuePairs;
    private String language;
    private String notificationEmail;
    private String notificationEmailType;
    private String projectId;
    private String scheduler;
    private String screenshotsDirectory;
    private String testCasesSelect;
    private String testCasesValue;
    private String testRunName;
    private String testRunner;
    private String withAnnotation;
    private String withoutAnnotation;
    private String testTimeout;
    private String credentialsId;
    private String cloudUrl;
    private boolean waitForResults;
    private String testRunStateCheckMethod;
    private String hookURL;
    private String waitForResultsTimeout;
    private String resultsPath;
    private boolean downloadScreenshots;
    private boolean forceFinishAfterBreak;

    @DataBoundConstructor
    public PipelineCloudStep(String projectId, String deviceGroupId) {
        this.projectId = projectId;
        this.deviceGroupId = deviceGroupId;
    }

    @DataBoundSetter
    public void setTestRunName(String testRunName) {
        this.testRunName = testRunName;
    }

    @DataBoundSetter
    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    @DataBoundSetter
    public void setTestRunner(String testRunner) {
        this.testRunner = testRunner;
    }

    @DataBoundSetter
    public void setTestPath(String testPath) {
        this.testPath = testPath;
    }

    @DataBoundSetter
    public void setScreenshotsDirectory(String screenshotsDirectory) {
        this.screenshotsDirectory = screenshotsDirectory;
    }

    @DataBoundSetter
    public void setKeyValuePairs(String keyValuePairs) {
        this.keyValuePairs = keyValuePairs;
    }

    @DataBoundSetter
    public void setWithAnnotation(String withAnnotation) {
        this.withAnnotation = withAnnotation;
    }

    @DataBoundSetter
    public void setWithoutAnnotation(String withoutAnnotation) {
        this.withoutAnnotation = withoutAnnotation;
    }

    @DataBoundSetter
    public void setTestCasesSelect(String testCasesSelect) {
        this.testCasesSelect = testCasesSelect;
    }

    @DataBoundSetter
    public void setTestCasesValue(String testCasesValue) {
        this.testCasesValue = testCasesValue;
    }

    @DataBoundSetter
    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    @DataBoundSetter
    public void setLanguage(String language) {
        this.language = language;
    }

    @DataBoundSetter
    public void setScheduler(String scheduler) {
        this.scheduler = scheduler.toLowerCase();
    }

    @DataBoundSetter
    public void setNotificationEmail(String notificationEmail) {
        this.notificationEmail = notificationEmail;
    }

    @DataBoundSetter
    public void setNotificationEmailType(String notificationEmailType) {
        this.notificationEmailType = notificationEmailType;
    }

    @DataBoundSetter
    public void setTestTimeout(String testTimeout) {
        this.testTimeout = testTimeout;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setCloudUrl(String cloudUrl) {
        this.cloudUrl = cloudUrl;
    }

    @DataBoundSetter
    public void setFailBuildIfThisStepFailed(boolean failBuildIfThisStepFailed) {
        this.failBuildIfThisStepFailed = failBuildIfThisStepFailed;
    }

    @DataBoundSetter
    public void setWaitForResults(boolean waitForResults) {
        this.waitForResults = waitForResults;
    }

    @DataBoundSetter
    public void setTestRunStateCheckMethod(String testRunStateCheckMethod) {
        this.testRunStateCheckMethod = testRunStateCheckMethod;
    }

    @DataBoundSetter
    public void setHookURL(String hookURL) {
        this.hookURL = hookURL;
    }

    @DataBoundSetter
    public void setWaitForResultsTimeout(String waitForResultsTimeout) {
        this.waitForResultsTimeout = waitForResultsTimeout;
    }

    @DataBoundSetter
    public void setResultsPath(String resultsPath) {
        this.resultsPath = resultsPath;
    }

    @DataBoundSetter
    public void setDownloadScreenshots(boolean downloadScreenshots) {
        this.downloadScreenshots = downloadScreenshots;
    }

    @DataBoundSetter
    public void setForceFinishAfterBreak(boolean forceFinishAfterBreak) {
        this.forceFinishAfterBreak = forceFinishAfterBreak;
    }

    private String getTestRunName() {
        return this.testRunName;
    }

    private String getAppPath() {
        return this.appPath;
    }

    private String getTestPath() {
        return this.testPath;
    }

    private String getProjectId() {
        return this.projectId;
    }

    private String getDeviceGroupId() {
        return this.deviceGroupId;
    }

    private String getTestRunner() {
        return this.testRunner;
    }

    private String getScreenshotsDirectory() {
        return this.screenshotsDirectory;
    }

    private String getKeyValuePairs() {
        return this.keyValuePairs;
    }

    private String getWithAnnotation() {
        return this.withAnnotation;
    }

    private String getWithoutAnnotation() {
        return this.withoutAnnotation;
    }

    private String getTestCasesSelect() {
        return this.testCasesSelect;
    }

    private String getTestCasesValue() {
        return this.testCasesValue;
    }

    private String getDataPath() {
        return this.dataPath;
    }

    private String getLanguage() {
        return this.language;
    }

    public String getScheduler() {
        return this.scheduler;
    }

    private String getNotificationEmail() {
        return this.notificationEmail;
    }

    private String getNotificationEmailType() {
        return this.notificationEmailType;
    }

    private boolean isFailBuildIfThisStepFailed() {
        return this.failBuildIfThisStepFailed;
    }

    private String getTestTimeout() {
        return this.testTimeout;
    }

    private String getCredentialsId() {
        return this.credentialsId;
    }

    public String getCloudUrl() {
        return this.cloudUrl;
    }

    private boolean isWaitForResults() {
        return this.waitForResults;
    }

    private String getTestRunStateCheckMethod() {
        return this.testRunStateCheckMethod;
    }

    private String getHookURL() {
        return this.hookURL;
    }

    private String getWaitForResultsTimeout() {
        return this.waitForResultsTimeout;
    }

    private String getResultsPath() {
        return this.resultsPath;
    }

    private boolean isDownloadScreenshots() {
        return this.downloadScreenshots;
    }

    private boolean isForceFinishAfterBreak() {
        return this.forceFinishAfterBreak;
    }

    public static final class CloudStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient PipelineCloudStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient FilePath workspace;

        protected Boolean run() throws Exception {
            WaitForResultsBlock waitForResultsBlock = null;
            if (this.step.isWaitForResults()) {
                waitForResultsBlock = new WaitForResultsBlock(this.step.getTestRunStateCheckMethod(), this.step.getHookURL(), this.step.getWaitForResultsTimeout(), this.step.getResultsPath(), this.step.isDownloadScreenshots(), this.step.isForceFinishAfterBreak());
            }
            RunInCloudBuilder builder = new RunInCloudBuilder(this.step.getProjectId(), this.step.getAppPath(), this.step.getTestPath(), this.step.getDataPath(), this.step.getTestRunName(), this.step.getScheduler(), this.step.getTestRunner(), this.step.getDeviceGroupId(), this.step.getLanguage(), this.step.getNotificationEmail(), this.step.getScreenshotsDirectory(), this.step.getKeyValuePairs(), this.step.getWithAnnotation(), this.step.getWithoutAnnotation(), this.step.getTestCasesSelect(), this.step.getTestCasesValue(), this.step.getNotificationEmailType(), this.step.isFailBuildIfThisStepFailed(), waitForResultsBlock, this.step.getTestTimeout(), this.step.getCredentialsId(), this.step.getCloudUrl());
            return builder.completeRun(this.run, this.workspace, this.launcher, this.listener);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(CloudStepExecution.class);
        }

        public String getFunctionName() {
            return "runInCloud";
        }

        public String getDisplayName() {
            return "Start a run in Bitbar Cloud";
        }
    }
}

