/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.remotesupport;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIException;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.model.APIDeviceRun;
import com.testdroid.api.model.APIScreenshot;
import com.testdroid.api.model.APITestRun;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.TestdroidCloudSettings;
import com.testdroid.jenkins.remotesupport.MachineIndependentTask;
import com.testdroid.jenkins.utils.TestdroidApiUtil;
import hudson.model.BuildListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class MachineIndependentResultsDownloader
extends MachineIndependentTask
implements Callable<Boolean, APIException> {
    private static final Logger LOGGER = Logger.getLogger(MachineIndependentResultsDownloader.class.getName());
    private boolean downloadScreenshots;
    private BuildListener listener;
    private long projectId;
    private String resultsPath;
    private long testRunId;

    public MachineIndependentResultsDownloader(TestdroidCloudSettings.DescriptorImpl descriptor, BuildListener listener, long projectId, long testRunId, String resultsPath, boolean downloadScreenshots) {
        super(descriptor);
        this.projectId = projectId;
        this.testRunId = testRunId;
        this.resultsPath = resultsPath;
        this.downloadScreenshots = downloadScreenshots;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean call() throws APIException {
        if (!TestdroidApiUtil.isInitialized()) {
            TestdroidApiUtil.init(this.user, this.password, this.cloudUrl, this.privateInstance, this.noCheckCertificate, this.isProxy, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
        }
        APIClient client = TestdroidApiUtil.getInstance().getTestdroidAPIClient();
        APITestRun testRun = client.me().getProject(Long.valueOf(this.projectId)).getTestRun(Long.valueOf(this.testRunId));
        boolean success = false;
        for (APIDeviceRun deviceRun : testRun.getDeviceRunsResource(new APIQueryBuilder().limit(Integer.MAX_VALUE)).getEntity().getData()) {
            String deviceDisplayName;
            block11: {
                FileOutputStream junitXmlOS = null;
                FileOutputStream logOS = null;
                FileOutputStream screenshotOS = null;
                deviceDisplayName = deviceRun.getDevice().getDisplayName();
                File resultDir = new File(String.format("%s/testdroid_result-%s-%d", this.resultsPath.endsWith(File.pathSeparator) ? this.resultsPath.substring(0, this.resultsPath.length() - File.pathSeparator.length()) : this.resultsPath, deviceDisplayName.replaceAll(" ", "_"), deviceRun.getId()));
                if (deviceRun.getRunStatus() == APIDeviceRun.RunStatus.EXCLUDED || deviceRun.getInterruptedByState() != null && deviceRun.getTestCaseAllNo() <= 0) break block11;
                try {
                    resultDir.mkdir();
                    junitXmlOS = new FileOutputStream(new File(resultDir, "TEST-all.xml"));
                    IOUtils.copy((InputStream)deviceRun.getJunitXml(), (OutputStream)junitXmlOS);
                    logOS = new FileOutputStream(new File(resultDir, "logcat.txt"));
                    IOUtils.copy((InputStream)deviceRun.getLogs(), (OutputStream)logOS);
                    success = true;
                }
                catch (Exception e) {
                    try {
                        String msg = String.format(Messages.DOWNLOAD_RESULTS_FROM_DEVICE_FAILED_S(), deviceDisplayName);
                        this.listener.getLogger().println(msg);
                        LOGGER.log(Level.WARNING, msg, e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(junitXmlOS);
                        IOUtils.closeQuietly(logOS);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)junitXmlOS);
                    IOUtils.closeQuietly((OutputStream)logOS);
                }
                IOUtils.closeQuietly((OutputStream)junitXmlOS);
                IOUtils.closeQuietly((OutputStream)logOS);
                if (!this.downloadScreenshots) continue;
                resultDir = new File(resultDir, "screenshots");
                resultDir.mkdir();
                for (APIScreenshot screenshot : deviceRun.getScreenshotsResource(new APIQueryBuilder().limit(Integer.MAX_VALUE)).getEntity().getData()) {
                    try {
                        screenshotOS = new FileOutputStream(new File(resultDir, screenshot.getOriginalName()));
                        IOUtils.copy((InputStream)screenshot.getContent(), (OutputStream)screenshotOS);
                    }
                    catch (Exception e) {
                        try {
                            String msg = String.format(Messages.DOWNLOAD_SCREENSHOT_FROM_DEVICE_FAILED_S_S(), screenshot.getOriginalName(), deviceDisplayName);
                            this.listener.getLogger().println(msg);
                            LOGGER.log(Level.WARNING, msg, e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(screenshotOS);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((OutputStream)screenshotOS);
                        continue;
                    }
                    IOUtils.closeQuietly((OutputStream)screenshotOS);
                }
                continue;
            }
            this.listener.getLogger().println(String.format(Messages.NO_RESULT_FROM_DEVICE_TEST_WAS_NOT_LAUNCHED_S(), deviceDisplayName));
        }
        return success;
    }
}

