/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.dataset;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import ham_fisted.IMutList;
import org.roaringbitmap.RoaringBitmap;
import tech.v3.dataset.PParser;
import tech.v3.datatype.ECount;
import tech.v3.datatype.IndexConsumer;

public class IntColParser
implements IDeref,
PParser,
ECount {
    public final IndexConsumer data;
    public final RoaringBitmap missing;
    public final Object colname;
    long lastidx;

    public IntColParser(IFn iFn, IMutList iMutList, Object object) {
        this.data = new IndexConsumer(iFn, iMutList);
        this.missing = new RoaringBitmap();
        this.colname = object;
    }

    public long lsize() {
        return this.lastidx;
    }

    public void addMissing(long l) {
        if (this.lastidx < l) {
            this.missing.add(this.lastidx, l);
        }
        this.lastidx = l + 1L;
    }

    @Override
    public void addValue(long l, Object object) {
        this.addMissing(l);
        if (object instanceof Long) {
            this.data.accept(((Long)object).longValue());
        } else if (object instanceof Integer) {
            this.data.accept((long)((Integer)object).intValue());
        } else if (object instanceof Short) {
            this.data.accept((long)((Short)object).shortValue());
        } else if (object instanceof Byte) {
            this.data.accept((long)((Byte)object).byteValue());
        } else if (object == null) {
            this.missing.add((int)l);
        } else {
            throw new RuntimeException("Value " + String.valueOf(object) + " is not an integer value");
        }
    }

    public Object deref() {
        return new PersistentArrayMap(new Object[]{Keyword.intern((String)"tech.v3.dataset", (String)"data"), this.data.deref(), Keyword.intern((String)"tech.v3.dataset", (String)"missing"), this.missing, Keyword.intern((String)"tech.v3.dataset", (String)"name"), this.colname});
    }

    @Override
    public Object finalize(long l) {
        this.addMissing(l);
        return this.deref();
    }
}

