/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.chart.PieChart;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.plotting.fx.FxBuilder;

public class FxPie
extends FxBuilder {
    public static PieChart chart(String title, Table table, String categoryColumnName, String numberColumnName) {
        StringColumn stringColumn = table.stringColumn(categoryColumnName);
        NumberColumn numberColumn = table.nCol(numberColumnName);
        return FxPie.chart(title, stringColumn, numberColumn);
    }

    public static PieChart chart(String title, StringColumn stringColumn, NumberColumn numberColumn) {
        ArrayList<PieChart.Data> data = new ArrayList<PieChart.Data>(stringColumn.size());
        for (int i = 0; i < stringColumn.size(); ++i) {
            data.add(new PieChart.Data(stringColumn.getString(i), numberColumn.get(i)));
        }
        return FxPie.createChart(title, data);
    }

    public static PieChart chart(String title, NumberColumn categoryColumn, NumberColumn numberColumn) {
        ArrayList<PieChart.Data> data = new ArrayList<PieChart.Data>(categoryColumn.size());
        for (int i = 0; i < categoryColumn.size(); ++i) {
            String name = Integer.toString(categoryColumn.roundInt(i));
            data.add(new PieChart.Data(name, numberColumn.get(i)));
        }
        return FxPie.createChart(title, data);
    }

    private static PieChart createChart(String title, List<PieChart.Data> data) {
        PieChart pieChart = FxPie.getPieChart(title);
        pieChart.getData().setAll(data);
        return pieChart;
    }
}

