/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api.plot;

import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Scene;
import javafx.scene.chart.BarChart;
import javax.swing.SwingUtilities;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.plotting.fx.FxBuilder;
import tech.tablesaw.plotting.fx.FxPareto;
import tech.tablesaw.plotting.fx.FxPlot;

public class Pareto
extends FxBuilder {
    private static final String WINDOW_TITLE = "Tablesaw";

    public static void show(String title, Table table) {
        SwingUtilities.invokeLater(() -> {
            try {
                if (table.column(0) instanceof StringColumn) {
                    Pareto.initAndShowGUI(title, table.stringColumn(0), table.nCol(1), 640, 480);
                }
                if (table.column(0) instanceof DoubleColumn) {
                    Pareto.initAndShowGUI(title, table.numberColumn(0), table.nCol(1), 640, 480);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
    }

    public static void show(String title, StringColumn stringColumn, NumberColumn numberColumn) {
        SwingUtilities.invokeLater(() -> {
            try {
                Pareto.initAndShowGUI(title, stringColumn, numberColumn, 640, 480);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
    }

    public static void show(String title, NumberColumn categoryColumn, NumberColumn numberColumn) {
        SwingUtilities.invokeLater(() -> {
            try {
                Pareto.initAndShowGUI(title, categoryColumn, numberColumn, 640, 480);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
    }

    private static void initAndShowGUI(String title, StringColumn stringColumn, NumberColumn numberColumn, int width, int height) {
        JFXPanel fxPanel = FxPlot.getJfxPanel(WINDOW_TITLE, width, height);
        BarChart<String, Number> chart = FxPareto.chart(title, stringColumn, numberColumn);
        Platform.runLater(() -> Pareto.initFX(fxPanel, chart));
    }

    private static void initAndShowGUI(String title, NumberColumn categoryColumn, NumberColumn numberColumn, int width, int height) {
        JFXPanel fxPanel = FxPlot.getJfxPanel(WINDOW_TITLE, width, height);
        BarChart<String, Number> chart = FxPareto.chart(title, categoryColumn, numberColumn);
        Platform.runLater(() -> Pareto.initFX(fxPanel, chart));
    }

    private static void initFX(JFXPanel fxPanel, BarChart<String, Number> chart) {
        Scene scene = new Scene(chart, chart.getWidth(), chart.getHeight());
        fxPanel.setScene(scene);
    }
}

