/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.fx;

import java.util.ArrayList;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public class FxTable
extends TableView<Integer> {
    private Table tableData;

    private FxTable() {
    }

    public static FxTable build() {
        FxTable tableSawFxViewer = new FxTable();
        return tableSawFxViewer;
    }

    public static FxTable build(Table table) {
        FxTable tableSawFxViewer = FxTable.build();
        tableSawFxViewer.setData(table);
        return tableSawFxViewer;
    }

    public void setData(Table table) {
        this.tableData = table;
        this.refreshTableView();
    }

    public void refreshTableView() {
        if (this.tableData == null) {
            return;
        }
        ObservableList data = FXCollections.observableArrayList();
        for (int i = 0; i < this.tableData.rowCount(); ++i) {
            data.add((Object)i);
        }
        ArrayList<TableColumn> columnsList = new ArrayList<TableColumn>();
        for (int iCol = 0; iCol < this.tableData.columnCount(); ++iCol) {
            TableColumn newColumn = this.createColumn(this.tableData.column(iCol));
            columnsList.add(newColumn);
        }
        this.setItems(data);
        this.getColumns().setAll(columnsList);
    }

    private TableColumn createColumn(final Column col) {
        TableColumn stringColumn = new TableColumn(col.name());
        stringColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Integer, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Integer, String> param) {
                int rowIndex = (Integer)param.getValue();
                String name = col.getString(rowIndex);
                return new SimpleStringProperty(name);
            }
        });
        return stringColumn;
    }
}

