/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.xchart;

import java.util.Arrays;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Theme;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.plotting.xchart.TablesawTheme;
import tech.tablesaw.table.TemporaryView;
import tech.tablesaw.table.ViewGroup;
import tech.tablesaw.util.DoubleArrays;

public class XchartScatter {
    public static void show(String chartTitle, NumericColumn yColumn) {
        double[] x = DoubleArrays.toN((int)yColumn.size());
        XchartScatter.show(chartTitle, x, yColumn, 600, 400);
    }

    public static void show(String chartTitle, NumericColumn xColumn, NumericColumn yColumn, int markerSize) {
        XchartScatter.show(chartTitle, xColumn, yColumn, 600, 400, markerSize);
    }

    public static void show(String chartTitle, NumericColumn xColumn, NumericColumn yColumn) {
        int markerSize = 3;
        XchartScatter.show(chartTitle, xColumn, yColumn, 600, 400, markerSize);
    }

    public static void show(String chartTitle, NumericColumn xColumn, NumericColumn yColumn, ViewGroup group) {
        XYChart chart = new XYChart(600, 400);
        chart.setTitle(chartTitle);
        chart.setXAxisTitle(xColumn.name());
        chart.setYAxisTitle(yColumn.name());
        ((XYStyler)chart.getStyler()).setTheme((Theme)new TablesawTheme());
        ((XYStyler)chart.getStyler()).setMarkerSize(5);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        for (TemporaryView view : group) {
            double[] xData = view.numericColumn(xColumn.name()).toDoubleArray();
            double[] yData = view.numericColumn(yColumn.name()).toDoubleArray();
            chart.addSeries(view.name(), Arrays.copyOf(xData, xData.length), Arrays.copyOf(yData, yData.length));
        }
        new SwingWrapper((Chart)chart).displayChart("Tablesaw");
    }

    public static void show(String chartTitle, NumericColumn xColumn, NumericColumn yColumn, ViewGroup group, int markerSize) {
        XYChart chart = new XYChart(600, 400);
        chart.setTitle(chartTitle);
        chart.setXAxisTitle(xColumn.name());
        chart.setYAxisTitle(yColumn.name());
        ((XYStyler)chart.getStyler()).setTheme((Theme)new TablesawTheme());
        ((XYStyler)chart.getStyler()).setMarkerSize(markerSize);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        for (TemporaryView view : group) {
            double[] xData = view.numericColumn(xColumn.name()).toDoubleArray();
            double[] yData = view.numericColumn(yColumn.name()).toDoubleArray();
            chart.addSeries(view.name(), Arrays.copyOf(xData, xData.length), Arrays.copyOf(yData, yData.length));
        }
        new SwingWrapper((Chart)chart).displayChart("Tablesaw");
    }

    public static void show(String chartTitle, NumericColumn xColumn, NumericColumn yColumn, int width, int height, int markerSize) {
        double[] xData = xColumn.toDoubleArray();
        double[] yData = yColumn.toDoubleArray();
        XYChart chart = new XYChart(width, height);
        chart.setTitle(chartTitle);
        chart.setXAxisTitle(xColumn.name());
        chart.setYAxisTitle(yColumn.name());
        ((XYStyler)chart.getStyler()).setTheme((Theme)new TablesawTheme());
        ((XYStyler)chart.getStyler()).setMarkerSize(markerSize);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        XYSeries series = chart.addSeries(yColumn.name() + " by " + xColumn.name(), xData, yData);
        series.setMarker(SeriesMarkers.CIRCLE);
        new SwingWrapper((Chart)chart).displayChart("Tablesaw");
    }

    public static void show(String chartTitle, double[] xData, NumericColumn yColumn, int width, int height) {
        double[] yData = yColumn.toDoubleArray();
        XYChart chart = new XYChart(width, height);
        chart.setTitle(chartTitle);
        chart.setYAxisTitle(yColumn.name());
        ((XYStyler)chart.getStyler()).setTheme((Theme)new TablesawTheme());
        ((XYStyler)chart.getStyler()).setMarkerSize(2);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        XYSeries series = chart.addSeries("Ranked: " + yColumn.name(), xData, yData);
        series.setMarker(SeriesMarkers.CIRCLE);
        new SwingWrapper((Chart)chart).displayChart("Tablesaw");
    }

    public static void show(String chartTitle, double[] xData, String xLabel, double[] yData, String yLabel, int width, int height) {
        XYChart chart = new XYChart(width, height);
        chart.setTitle(chartTitle);
        chart.setXAxisTitle(xLabel);
        chart.setYAxisTitle(yLabel);
        ((XYStyler)chart.getStyler()).setTheme((Theme)new TablesawTheme());
        ((XYStyler)chart.getStyler()).setMarkerSize(5);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        XYSeries series = chart.addSeries("series 1", xData, yData);
        series.setMarker(SeriesMarkers.CIRCLE);
        new SwingWrapper((Chart)chart).displayChart("Tablesaw");
    }

    public static void show(String chartTitle, String xTitle, double[] x, String yTitle, double[] y) {
        XYChart chart = new XYChart(600, 400);
        chart.setTitle(chartTitle);
        chart.setXAxisTitle(xTitle);
        chart.setYAxisTitle(yTitle);
        ((XYStyler)chart.getStyler()).setTheme((Theme)new TablesawTheme());
        ((XYStyler)chart.getStyler()).setMarkerSize(4);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        XYSeries series = chart.addSeries(chartTitle, x, y);
        series.setMarker(SeriesMarkers.CIRCLE);
        new SwingWrapper((Chart)chart).displayChart("Tablesaw");
    }
}

