/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.fx;

import java.util.List;
import javafx.collections.FXCollections;
import javafx.geometry.Side;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.Background;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.columns.Column;

public class FxBuilder {
    static NumberAxis getNumberAxis(NumericColumn numericColumn) {
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setLabel(numericColumn.name());
        return numberAxis;
    }

    static CategoryAxis getCategoryAxis(Column categoryColumn) {
        CategoryAxis categoryAxis = new CategoryAxis();
        categoryAxis.setLabel(categoryColumn.name());
        return categoryAxis;
    }

    static XYChart.Series<String, Number> getSeries(NumericColumn numericColumn, List<XYChart.Data<String, Number>> data) {
        XYChart.Series series1 = new XYChart.Series(FXCollections.observableList(data));
        series1.setName(numericColumn.name());
        return series1;
    }

    static BarChart<String, Number> getBarChart(String title, CategoryAxis categoryAxis, NumberAxis numberAxis) {
        BarChart bar = new BarChart((Axis)categoryAxis, (Axis)numberAxis);
        bar.setTitle(title);
        bar.setLegendVisible(false);
        bar.setCategoryGap(0.0);
        bar.setBarGap(0.1);
        bar.setBackground(Background.EMPTY);
        bar.setVerticalGridLinesVisible(false);
        return bar;
    }

    static PieChart getPieChart(String title) {
        PieChart pie = new PieChart();
        pie.setTitle(title);
        pie.setLegendVisible(false);
        pie.setBackground(Background.EMPTY);
        pie.setLegendVisible(true);
        pie.setLegendSide(Side.RIGHT);
        return pie;
    }
}

