/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.HoverLabel;
import tech.tablesaw.plotly.components.TemplateUtils;
import tech.tablesaw.plotly.traces.Trace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public abstract class AbstractTrace
implements Trace {
    protected static final double DEFAULT_OPACITY = 1.0;
    protected static final Visibility DEFAULT_VISIBILITY = Visibility.TRUE;
    protected final PebbleEngine engine = TemplateUtils.getNewEngine();
    protected final String type;
    private final Visibility visible;
    private final Boolean showLegend;
    private final String legendGroup;
    private final double opacity;
    private final String name;
    private final String[] ids;
    private final String xAxis;
    private final String yAxis;
    private final HoverLabel hoverLabel;

    public AbstractTrace(TraceBuilder builder) {
        this.type = builder.getType();
        this.name = builder.name;
        this.showLegend = builder.showLegend;
        this.legendGroup = builder.legendGroup;
        this.visible = builder.visible;
        this.ids = builder.ids;
        this.hoverLabel = builder.hoverLabel;
        this.opacity = builder.opacity;
        this.xAxis = builder.xAxis;
        this.yAxis = builder.yAxis;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("trace_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ((Object)writer).toString();
    }

    protected Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("type", this.type);
        context.put("name", this.name);
        if (this.showLegend != null) {
            context.put("showLegend", this.showLegend);
        }
        context.put("legendGroup", this.legendGroup);
        if (!this.visible.equals((Object)DEFAULT_VISIBILITY)) {
            context.put("visible", (Object)this.visible);
        }
        context.put("ids", this.ids);
        context.put("hoverLable", this.hoverLabel);
        if (this.opacity != 1.0) {
            context.put("opacity", this.opacity);
        }
        context.put("xAxis", this.xAxis);
        context.put("yAxis", this.yAxis);
        return context;
    }

    @Override
    public HoverLabel hoverLabel() {
        return this.hoverLabel;
    }

    @Override
    public boolean showLegend() {
        return this.showLegend;
    }

    public static enum Visibility {
        TRUE("True"),
        FALSE("False"),
        LEGEND_ONLY("legendonly");

        private final String value;

        private Visibility(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

