/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.plotly.components.TemplateUtils;

public abstract class Component {
    protected static final ObjectMapper mapper = new ObjectMapper();
    private final PebbleEngine engine = TemplateUtils.getNewEngine();

    protected PebbleEngine getEngine() {
        return this.engine;
    }

    @Deprecated
    public abstract String asJavascript();

    @Deprecated
    protected abstract Map<String, Object> getContext();

    protected Map<String, Object> getJSONContext() {
        return null;
    }

    public String asJSON() {
        StringWriter w = new StringWriter();
        try {
            mapper.writeValue((Writer)w, this.getJSONContext());
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        return w.toString();
    }

    protected String asJavascript(String filename) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.getEngine().getTemplate(filename);
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ((Object)writer).toString();
    }

    public String toString() {
        return this.asJavascript();
    }

    static {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
    }
}

