/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.google.common.base.Preconditions;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.tablesaw.plotly.components.Config;
import tech.tablesaw.plotly.components.Layout;
import tech.tablesaw.plotly.components.TemplateUtils;
import tech.tablesaw.plotly.event.EventHandler;
import tech.tablesaw.plotly.traces.Trace;

public class Figure {
    private Trace[] data;
    private Layout layout;
    private Config config;
    private EventHandler[] eventHandlers;
    private final Map<String, Object> context = new HashMap<String, Object>();
    private final PebbleEngine engine = TemplateUtils.getNewEngine();

    public Figure(FigureBuilder builder) {
        this.data = builder.traces();
        this.layout = builder.layout;
        this.config = builder.config;
        this.eventHandlers = builder.eventHandlers();
    }

    public Figure(Trace ... traces) {
        this((Layout)null, traces);
    }

    public Figure(Layout layout, Trace ... traces) {
        this(layout, (Config)null, traces);
    }

    public Figure(Layout layout, Config config, Trace ... traces) {
        this.data = traces;
        this.layout = layout;
        this.config = config;
        this.eventHandlers = null;
    }

    public String divString(String divName) {
        return String.format("<div id='%s' ></div>" + System.lineSeparator(), divName);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public EventHandler[] getEventHandlers() {
        return this.eventHandlers;
    }

    public void setEventHandlers(EventHandler ... handlers) {
        this.eventHandlers = handlers;
    }

    public Trace[] getTraces() {
        return this.data;
    }

    public void setTraces(Trace ... data) {
        this.data = data;
    }

    public String asJavascript(String divName) {
        StringWriter writer = new StringWriter();
        this.buildContext(divName);
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("figure_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ((Object)writer).toString();
    }

    protected void buildContext(String divName) {
        String targetName = "target_" + divName;
        this.context.put("divName", divName);
        this.context.put("targetName", targetName);
        StringBuilder builder = new StringBuilder();
        if (this.layout != null) {
            builder.append(this.layout.asJavascript());
        }
        if (this.config != null) {
            builder.append(this.config.asJavascript());
        }
        builder.append(System.lineSeparator());
        for (int i = 0; i < this.data.length; ++i) {
            Trace trace = this.data[i];
            builder.append(trace.asJavascript(i));
            builder.append(System.lineSeparator());
        }
        builder.append(System.lineSeparator());
        String figure = builder.toString();
        this.context.put("figure", figure);
        this.context.put("plotFunction", this.plotFunction(targetName));
        this.context.put("eventHandlerFunction", this.eventHandlerFunction(targetName, divName));
    }

    protected String plotFunction(String divName) {
        StringBuilder builder = new StringBuilder();
        builder.append("var data = [ ");
        for (int i = 0; i < this.data.length; ++i) {
            builder.append("trace").append(i);
            if (i >= this.data.length - 1) continue;
            builder.append(", ");
        }
        builder.append("];").append(System.lineSeparator());
        builder.append("Plotly.newPlot(").append(divName).append(", ").append("data");
        if (this.layout != null) {
            builder.append(", ");
            builder.append("layout");
        }
        if (this.config != null) {
            builder.append(", ");
            builder.append("config");
        }
        builder.append(");");
        return builder.toString();
    }

    protected String eventHandlerFunction(String targetName, String divName) {
        StringBuilder builder = new StringBuilder();
        if (this.eventHandlers != null) {
            builder.append(System.lineSeparator());
            for (EventHandler eventHandler : this.eventHandlers) {
                builder.append(eventHandler.asJavascript(targetName, divName));
            }
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public static FigureBuilder builder() {
        return new FigureBuilder();
    }

    public static class FigureBuilder {
        private Layout layout;
        private Config config;
        private List<Trace> traces = new ArrayList<Trace>();
        private List<EventHandler> eventHandlers = new ArrayList<EventHandler>();

        public FigureBuilder layout(Layout layout) {
            this.layout = layout;
            return this;
        }

        public FigureBuilder config(Config config) {
            this.config = config;
            return this;
        }

        public FigureBuilder addTraces(Trace ... traces) {
            this.traces.addAll(Arrays.asList(traces));
            return this;
        }

        public FigureBuilder addEventHandlers(EventHandler ... handlers) {
            this.eventHandlers.addAll(Arrays.asList(handlers));
            return this;
        }

        public Figure build() {
            Preconditions.checkState((!this.traces.isEmpty() ? 1 : 0) != 0, (Object)"A figure must have at least one trace");
            return new Figure(this);
        }

        private EventHandler[] eventHandlers() {
            return this.eventHandlers.toArray(new EventHandler[0]);
        }

        private Trace[] traces() {
            return this.traces.toArray(new Trace[0]);
        }
    }
}

