/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.google.common.base.Preconditions;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.components.Component;
import tech.tablesaw.plotly.components.Font;
import tech.tablesaw.plotly.components.TickSettings;
import tech.tablesaw.plotly.traces.ScatterTrace;

public class Axis
extends Component {
    private static final String DEFAULT_COLOR = "#444";
    private static final String DEFAULT_ZERO_LINE_COLOR = "#444";
    private static final String DEFAULT_LINE_COLOR = "#444";
    private static final String DEFAULT_GRID_COLOR = "#eee";
    private static final int DEFAULT_LINE_WIDTH = 1;
    private static final int DEFAULT_ZERO_LINE_WIDTH = 1;
    private static final int DEFAULT_GRID_WIDTH = 1;
    private static final boolean DEFAULT_SHOW_LINE = true;
    private static final boolean DEFAULT_SHOW_GRID = true;
    private static final boolean DEFAULT_ZERO_LINE = false;
    private static final double DEFAULT_SCALE_RATIO = 1.0;
    private static final Constrain DEFAULT_CONSTRAIN_RANGE = Constrain.RANGE;
    private static final AutoRange DEFAULT_AUTO_RANGE = AutoRange.TRUE;
    private static final Type DEFAULT_TYPE = Type.DEFAULT;
    private static final boolean DEFAULT_VISIBLE = true;
    private final String title;
    private final boolean visible;
    private final String color;
    private final Font font;
    private final Font titleFont;
    private final Type type;
    private final RangeMode rangeMode;
    private final AutoRange autoRange;
    private final Object[] range;
    private final boolean fixedRange;
    private final Constrain constrain;
    private final ConstrainToward constrainToward;
    private final double scaleRatio;
    private final Spikes spikes;
    private final int lineWidth;
    private final int zeroLineWidth;
    private final int gridWidth;
    private final String lineColor;
    private final String zeroLineColor;
    private final String gridColor;
    private final boolean showLine;
    private final boolean zeroLine;
    private final boolean showGrid;
    private final Side side;
    private final ScatterTrace.YAxis overlaying;
    private final CategoryOrder categoryOrder;
    private final TickSettings tickSettings;
    private final float[] domain;

    public static AxisBuilder builder() {
        return new AxisBuilder();
    }

    private Axis(AxisBuilder builder) {
        this.title = builder.title;
        this.titleFont = builder.titleFont;
        this.type = builder.type;
        this.visible = builder.visible;
        this.color = builder.color;
        this.font = builder.font;
        this.autoRange = builder.autoRange;
        this.range = builder.range;
        this.rangeMode = builder.rangeMode;
        this.fixedRange = builder.fixedRange;
        this.tickSettings = builder.tickSettings;
        this.side = builder.side;
        this.overlaying = builder.overlaying;
        this.spikes = builder.spikes;
        this.showLine = builder.showLine;
        this.zeroLine = builder.zeroLine;
        this.showGrid = builder.showGrid;
        this.lineColor = builder.lineColor;
        this.zeroLineColor = builder.zeroLineColor;
        this.gridColor = builder.gridColor;
        this.lineWidth = builder.lineWidth;
        this.zeroLineWidth = builder.zeroLineWidth;
        this.gridWidth = builder.gridWidth;
        this.constrain = builder.constrain;
        this.constrainToward = builder.constrainToward;
        this.scaleRatio = builder.scaleRatio;
        this.categoryOrder = builder.categoryOrder;
        this.domain = builder.domain;
    }

    @Override
    public String asJavascript() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("axis_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("title", this.title);
        context.put("titleFont", this.titleFont);
        if (!this.visible) {
            context.put("visible", this.visible);
        }
        if (!this.type.equals((Object)DEFAULT_TYPE)) {
            context.put("type", (Object)this.type);
        }
        if (!this.color.equals("#444")) {
            context.put("color", this.color);
        }
        if (this.font != null) {
            context.put("font", this.font);
        }
        if (this.side != null) {
            context.put("side", (Object)this.side);
        }
        if (this.overlaying != null) {
            context.put("overlaying", (Object)this.overlaying);
        }
        if (!this.autoRange.equals((Object)DEFAULT_AUTO_RANGE)) {
            context.put("autoRange", (Object)this.autoRange);
        }
        context.put("rangeMode", (Object)this.rangeMode);
        if (this.range != null) {
            context.put("range", Utils.dataAsString(this.range));
        }
        context.put("fixedRange", this.fixedRange);
        if (this.scaleRatio != 1.0) {
            context.put("scaleRatio", this.scaleRatio);
        }
        if (!this.constrain.equals((Object)DEFAULT_CONSTRAIN_RANGE)) {
            context.put("constrain", (Object)this.constrain);
        }
        if (this.constrainToward != null) {
            context.put("constrainToward", (Object)this.constrainToward);
        }
        if (this.spikes != null) {
            this.spikes.updateContext(context);
        }
        if (this.tickSettings != null) {
            this.tickSettings.updateContext(context);
        }
        if (this.categoryOrder != null) {
            context.put("categoryOrder", (Object)this.categoryOrder);
        }
        if (this.gridWidth != 1) {
            context.put("gridWidth", this.gridWidth);
        }
        if (this.lineWidth != 1) {
            context.put("lineWidth", this.lineWidth);
        }
        if (this.zeroLineWidth != 1) {
            context.put("zeroLineWidth", this.zeroLineWidth);
        }
        if (!this.lineColor.equals("#444")) {
            context.put("lineColor", this.lineColor);
        }
        if (!this.zeroLineColor.equals("#444")) {
            context.put("zeroLineColor", this.zeroLineColor);
        }
        if (!this.gridColor.equals(DEFAULT_GRID_COLOR)) {
            context.put("gridColor", this.gridColor);
        }
        if (!this.showLine) {
            context.put("showLine", this.showLine);
        }
        if (this.zeroLine) {
            context.put("zeroLine", this.zeroLine);
        }
        if (!this.showGrid) {
            context.put("showGrid", this.showGrid);
        }
        if (this.domain != null) {
            context.put("domain", String.format("[%.2f, %.2f]", Float.valueOf(this.domain[0]), Float.valueOf(this.domain[1])));
        }
        return context;
    }

    static /* synthetic */ Constrain access$3000() {
        return DEFAULT_CONSTRAIN_RANGE;
    }

    static /* synthetic */ Type access$3100() {
        return DEFAULT_TYPE;
    }

    static /* synthetic */ AutoRange access$3200() {
        return DEFAULT_AUTO_RANGE;
    }

    public static class Spikes {
        private final String color;
        private final int thickness;
        private final String dash;
        private final SpikeMode mode;
        private final SpikeSnap snap;

        private Spikes(SpikesBuilder builder) {
            this.color = builder.color;
            this.thickness = builder.thickness;
            this.dash = builder.dash;
            this.mode = builder.mode;
            this.snap = builder.snap;
        }

        private void updateContext(Map<String, Object> context) {
            context.put("showSpikes", true);
            context.put("spikeMode", (Object)this.mode);
            context.put("spikeThickness", this.thickness);
            context.put("spikeDash", this.dash);
            context.put("spikeColor", this.color);
            context.put("spikeSnap", (Object)this.snap);
        }

        public static SpikesBuilder builder() {
            return new SpikesBuilder();
        }

        public static class SpikesBuilder {
            private String color = null;
            private int thickness = 3;
            private String dash = "dash";
            private SpikeMode mode = SpikeMode.TO_AXIS;
            private SpikeSnap snap = SpikeSnap.DATA;

            private SpikesBuilder() {
            }

            public SpikesBuilder color(String color) {
                this.color = color;
                return this;
            }

            public SpikesBuilder dash(String dash) {
                this.dash = dash;
                return this;
            }

            public SpikesBuilder mode(SpikeMode mode) {
                this.mode = mode;
                return this;
            }

            public SpikesBuilder snap(SpikeSnap snap) {
                this.snap = snap;
                return this;
            }

            public SpikesBuilder thickness(int thickness) {
                this.thickness = thickness;
                return this;
            }

            public Spikes build() {
                return new Spikes(this);
            }
        }

        public static enum SpikeMode {
            TO_AXIS("toaxis"),
            ACROSS("across"),
            MARKER("marker"),
            TO_AXIS_AND_ACROSS("toaxis+across"),
            TO_AXIS_AND_MARKER("toaxis+marker"),
            ACROSS_AND_MARKER("across+marker"),
            TO_AXIS_AND_ACROSS_AND_MARKER("toaxis+across+marker");

            private final String value;

            private SpikeMode(String value) {
                this.value = value;
            }

            public String toString() {
                return this.value;
            }
        }

        public static enum SpikeSnap {
            DATA("data"),
            CURSOR("cursor");

            private final String value;

            private SpikeSnap(String value) {
                this.value = value;
            }

            public String toString() {
                return this.value;
            }
        }
    }

    public static class AxisBuilder {
        private Constrain constrain = Axis.access$3000();
        private ConstrainToward constrainToward;
        private double scaleRatio = 1.0;
        private Font titleFont;
        private String title = "";
        private boolean visible = true;
        private String color = "#444";
        private Font font;
        private Side side;
        private Type type = Axis.access$3100();
        private RangeMode rangeMode = RangeMode.NORMAL;
        private AutoRange autoRange = Axis.access$3200();
        private Object[] range;
        private boolean fixedRange = true;
        private TickSettings tickSettings;
        private Spikes spikes = null;
        private boolean showLine = true;
        private String lineColor = "#444";
        private int lineWidth = 1;
        private boolean zeroLine = false;
        private String zeroLineColor = "#444";
        private int zeroLineWidth = 1;
        private boolean showGrid = true;
        private String gridColor = "#eee";
        private int gridWidth = 1;
        private ScatterTrace.YAxis overlaying;
        private CategoryOrder categoryOrder;
        private float[] domain = null;

        private AxisBuilder() {
        }

        public AxisBuilder title(String title) {
            this.title = title;
            return this;
        }

        public AxisBuilder titleFont(Font titleFont) {
            this.titleFont = titleFont;
            return this;
        }

        public AxisBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public AxisBuilder categoryOrder(CategoryOrder categoryOrder) {
            this.categoryOrder = categoryOrder;
            return this;
        }

        public AxisBuilder domain(float start, float end) {
            this.domain = new float[]{start, end};
            return this;
        }

        public AxisBuilder visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public AxisBuilder side(Side side) {
            this.side = side;
            return this;
        }

        public AxisBuilder overlaying(ScatterTrace.YAxis axisToOverlay) {
            this.overlaying = axisToOverlay;
            return this;
        }

        public AxisBuilder fixedRange(boolean fixedRange) {
            this.fixedRange = fixedRange;
            return this;
        }

        public AxisBuilder color(String color) {
            this.color = color;
            return this;
        }

        public AxisBuilder font(Font font) {
            this.font = font;
            return this;
        }

        public AxisBuilder rangeMode(RangeMode rangeMode) {
            this.rangeMode = rangeMode;
            return this;
        }

        public AxisBuilder spikes(Spikes spikes) {
            this.spikes = spikes;
            return this;
        }

        public AxisBuilder autoRange(AutoRange autoRange) {
            this.autoRange = autoRange;
            if (this.range != null && autoRange != AutoRange.FALSE) {
                throw new IllegalArgumentException("Can't set autoRange to anything but FALSE after specifying a range.");
            }
            return this;
        }

        public AxisBuilder range(Object[] range) {
            this.range = range;
            this.autoRange = AutoRange.FALSE;
            return this;
        }

        public AxisBuilder range(Object low, Object high) {
            Object[] range = new Object[]{low, high};
            this.range = range;
            this.autoRange = AutoRange.FALSE;
            return this;
        }

        public AxisBuilder constrain(Constrain constrain) {
            this.constrain = constrain;
            return this;
        }

        public AxisBuilder constrainToward(ConstrainToward constrainToward) {
            this.constrainToward = constrainToward;
            return this;
        }

        public AxisBuilder scaleRatio(double scaleRatio) {
            Preconditions.checkArgument((scaleRatio >= 1.0 ? 1 : 0) != 0);
            this.scaleRatio = scaleRatio;
            return this;
        }

        public AxisBuilder tickSettings(TickSettings tickSettings) {
            this.tickSettings = tickSettings;
            return this;
        }

        public AxisBuilder lineWidth(int lineWidth) {
            Preconditions.checkArgument((lineWidth >= 0 ? 1 : 0) != 0);
            this.lineWidth = lineWidth;
            return this;
        }

        public AxisBuilder zeroLineWidth(int zeroLineWidth) {
            Preconditions.checkArgument((zeroLineWidth >= 0 ? 1 : 0) != 0);
            this.zeroLineWidth = zeroLineWidth;
            return this;
        }

        public AxisBuilder gridWidth(int width) {
            Preconditions.checkArgument((width >= 0 ? 1 : 0) != 0);
            this.gridWidth = width;
            return this;
        }

        public AxisBuilder lineColor(String color) {
            this.lineColor = color;
            return this;
        }

        public AxisBuilder gridColor(String color) {
            this.gridColor = color;
            return this;
        }

        public AxisBuilder zeroLineColor(String color) {
            this.zeroLineColor = color;
            return this;
        }

        public AxisBuilder showLine(boolean showLine) {
            this.showLine = showLine;
            return this;
        }

        public AxisBuilder showGrid(boolean showGrid) {
            this.showGrid = showGrid;
            return this;
        }

        public AxisBuilder showZeroLine(boolean zeroLine) {
            this.zeroLine = zeroLine;
            return this;
        }

        public Axis build() {
            return new Axis(this);
        }
    }

    public static enum Side {
        left("left"),
        right("right"),
        top("top"),
        bottom("bottom");

        private final String value;

        private Side(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum RangeMode {
        NORMAL("normal"),
        TO_ZERO("tozero"),
        NON_NEGATIVE("nonnegative");

        private final String value;

        private RangeMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ScaleAnchor {
        X("/^x([2-9]|[1-9][0-9]+)?$/"),
        Y("/^y([2-9]|[1-9][0-9]+)?$/");

        private final String value;

        private ScaleAnchor(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ConstrainToward {
        LEFT("left"),
        CENTER("center"),
        RIGHT("right"),
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String value;

        private ConstrainToward(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Constrain {
        RANGE("range"),
        DOMAIN("domain");

        private final String value;

        private Constrain(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum AutoRange {
        TRUE("true"),
        FALSE("false"),
        REVERSED("reversed");

        private final String value;

        private AutoRange(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Type {
        LINEAR("linear"),
        LOG("log"),
        DATE("date"),
        CATEGORY("category"),
        DEFAULT("-");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum CategoryOrder {
        TRACE("trace"),
        CATEGORY_ASCENDING("category ascending"),
        CATEGORY_DESCENDING("category descending"),
        ARRAY("array");

        private final String value;

        private CategoryOrder(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

