/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Component;
import tech.tablesaw.plotly.components.Figure;

public class Page
extends Component {
    private final Figure figure;
    private final String divName;
    private final String plotlyJsLocation;

    private Page(PageBuilder builder) {
        this.figure = builder.figure;
        this.divName = builder.divName;
        this.plotlyJsLocation = builder.plotlyJsLocation;
    }

    @Override
    public String asJavascript() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("page_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("figureScript", this.figure.asJavascript(this.divName));
        context.put("targetDiv", this.figure.divString(this.divName));
        context.put("figureTitle", this.figure.getLayout() != null ? this.figure.getLayout().getTitle() : null);
        context.put("plotlyJsLocation", this.plotlyJsLocation);
        return context;
    }

    public static PageBuilder pageBuilder(Figure figure, String divName) {
        return new PageBuilder(figure, divName);
    }

    public static class PageBuilder {
        private final Figure figure;
        private final String divName;
        private String plotlyJsLocation = null;

        public PageBuilder(Figure figure, String divName) {
            this.figure = figure;
            this.divName = divName;
        }

        public Page build() {
            return new Page(this);
        }

        public PageBuilder plotlyJsLocation(String location) {
            this.plotlyJsLocation = location;
            return this;
        }
    }
}

