/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.google.common.base.Preconditions;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.components.Component;
import tech.tablesaw.plotly.components.Symbol;

public class Marker
extends Component {
    private static final boolean DEFAULT_C_AUTO = true;
    private static final boolean DEFAULT_AUTO_COLOR_SCALE = true;
    private static final boolean DEFAULT_SHOW_SCALE = false;
    private static final boolean DEFAULT_REVERSE_SCALE = false;
    private static final double DEFAULT_OPACITY = 1.0;
    private static final SizeMode DEFAULT_SIZE_MODE = SizeMode.DIAMETER;
    private final double[] size;
    private final String[] color;
    private final Palette colorScalePalette;
    private final boolean cAuto;
    private final double cMin;
    private final double cMax;
    private final boolean autoColorScale;
    private final boolean showScale;
    private final boolean reverseScale;
    private final double opacity;
    private final Symbol symbol;
    private final SizeMode sizeMode;

    public static MarkerBuilder builder() {
        return new MarkerBuilder();
    }

    private Marker(MarkerBuilder builder) {
        this.symbol = builder.symbol;
        this.size = builder.size;
        this.color = builder.color;
        this.colorScalePalette = builder.colorScalePalette;
        this.cAuto = builder.cAuto;
        this.cMin = builder.cMin;
        this.cMax = builder.cMax;
        this.autoColorScale = builder.autoColorScale;
        this.showScale = builder.showScale;
        this.reverseScale = builder.reverseScale;
        this.opacity = builder.opacity;
        this.sizeMode = builder.sizeMode;
    }

    @Override
    public String asJavascript() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("marker_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("size", this.size.length == 1 ? Double.valueOf(this.size[0]) : Utils.dataAsString(this.size));
        if (this.colorScalePalette != null) {
            context.put("colorScale", (Object)this.colorScalePalette);
        }
        if (!this.cAuto) {
            context.put("cAuto", this.cAuto);
        }
        if (this.color != null && this.color.length > 0) {
            if (this.color.length > 1) {
                context.put("color", Utils.dataAsString(this.color));
                context.put("cMin", this.cMin);
                context.put("cMax", this.cMax);
            } else {
                context.put("color", Utils.quote(this.color[0]));
            }
        }
        if (!this.autoColorScale) {
            context.put("autoColorScale", this.autoColorScale);
        }
        if (this.showScale) {
            context.put("showScale", this.showScale);
        }
        if (this.reverseScale) {
            context.put("reverseScale", this.reverseScale);
        }
        if (this.opacity != 1.0) {
            context.put("opacity", this.opacity);
        }
        if (this.sizeMode != DEFAULT_SIZE_MODE) {
            context.put("sizeMode", (Object)this.sizeMode);
        }
        context.put("symbol", (Object)this.symbol);
        return context;
    }

    static /* synthetic */ SizeMode access$1200() {
        return DEFAULT_SIZE_MODE;
    }

    public static class MarkerBuilder {
        private double[] size = new double[]{6.0};
        private String[] color;
        private Palette colorScalePalette;
        private boolean cAuto = true;
        private double cMin;
        private double cMax;
        private boolean autoColorScale = true;
        private boolean showScale = false;
        private boolean reverseScale = false;
        private double opacity = 1.0;
        private Symbol symbol;
        private SizeMode sizeMode = Marker.access$1200();

        public MarkerBuilder size(double ... size) {
            String errorMessage = "All sizes in size array must be greater than 0.";
            for (double d : size) {
                Preconditions.checkArgument((d > 0.0 ? 1 : 0) != 0, (Object)errorMessage);
            }
            this.size = size;
            return this;
        }

        public MarkerBuilder size(NumberColumn<?> size) {
            return this.size(size.asDoubleArray());
        }

        public MarkerBuilder cAuto(boolean b) {
            this.cAuto = b;
            return this;
        }

        public MarkerBuilder reverseScale(boolean b) {
            this.reverseScale = b;
            return this;
        }

        public MarkerBuilder autoColorScale(boolean b) {
            this.autoColorScale = b;
            return this;
        }

        public MarkerBuilder cMinAndMax(double min, double max) {
            this.cMin = min;
            this.cMax = max;
            return this;
        }

        public MarkerBuilder showScale(boolean b) {
            this.showScale = b;
            return this;
        }

        public MarkerBuilder colorScale(Palette palette) {
            this.colorScalePalette = palette;
            return this;
        }

        public MarkerBuilder opacity(double opacity) {
            Preconditions.checkArgument((opacity >= 0.0 && opacity <= 1.0 ? 1 : 0) != 0);
            this.opacity = opacity;
            return this;
        }

        public MarkerBuilder color(String color) {
            this.color = new String[1];
            this.color[0] = color;
            return this;
        }

        public MarkerBuilder color(String[] color) {
            this.color = color;
            return this;
        }

        public MarkerBuilder symbol(Symbol symbol) {
            this.symbol = symbol;
            return this;
        }

        public MarkerBuilder sizeMode(SizeMode sizeMode) {
            this.sizeMode = sizeMode;
            return this;
        }

        public Marker build() {
            return new Marker(this);
        }
    }

    public static enum Palette {
        GREYS("Greys"),
        GREENS("Greens"),
        YL_GN_BU("YlGnBu"),
        YL_OR_RD("YlOrRd"),
        BLUE_RED("Bluered"),
        RD_BU("RdBu"),
        REDS("Reds"),
        BLUES("Blues"),
        PICNIC("Picnic"),
        RAINBOW("Rainbow"),
        PORTLAND("Portland"),
        JET("Jet"),
        HOT("Hot"),
        BLACKBODY("Blackbody"),
        EARTH("Earth"),
        ELECTRIC("Electric"),
        VIRIDIS("Viridis"),
        CIVIDIS("Cividis");

        private final String value;

        private Palette(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum SizeMode {
        AREA("area"),
        DIAMETER("diameter");

        private final String value;

        private SizeMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

