/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import com.google.common.base.Preconditions;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.components.HoverLabel;
import tech.tablesaw.plotly.components.Line;
import tech.tablesaw.plotly.components.Marker;
import tech.tablesaw.plotly.traces.AbstractTrace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public class ScatterTrace
extends AbstractTrace {
    private final double[] y;
    private final double[] x;
    private final String[] text;
    private final Mode mode;
    private final HoverLabel hoverLabel;
    private final boolean showLegend;
    private final Marker marker;
    private final Line line;

    public static ScatterBuilder builder(double[] x, double[] y) {
        return new ScatterBuilder(x, y);
    }

    public static ScatterBuilder builder(NumberColumn x, NumberColumn y) {
        return new ScatterBuilder(x, y);
    }

    private ScatterTrace(ScatterBuilder builder) {
        super(builder);
        this.mode = builder.mode;
        this.y = builder.y;
        this.x = builder.x;
        this.text = builder.text;
        this.marker = builder.marker;
        this.hoverLabel = builder.hoverLabel();
        this.showLegend = builder.showLegend();
        this.line = builder.line;
    }

    private Map<String, Object> getContext(int i) {
        Map<String, Object> context = super.getContext();
        context.put("variableName", "trace" + i);
        context.put("mode", (Object)this.mode);
        context.put("y", Utils.dataAsString(this.y));
        context.put("x", Utils.dataAsString(this.x));
        context.put("marker", this.marker);
        context.put("showlegend", this.showLegend);
        if (this.hoverLabel != null) {
            context.put("hoverlabel", this.hoverLabel.asJavascript());
        }
        if (this.line != null) {
            context.put("line", this.line.asJavascript());
        }
        if (this.text != null) {
            context.put("text", Utils.dataAsString(this.text));
        }
        return context;
    }

    @Override
    public String asJavascript(int i) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("trace_template.html");
            Map<String, Object> context = this.getContext(i);
            compiledTemplate.evaluate((Writer)writer, context);
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    public static class ScatterBuilder
    extends TraceBuilder {
        private String type = "scatter";
        private Mode mode = Mode.MARKERS;
        private double[] x;
        private double[] y;
        private String[] text;
        private Marker marker;
        private Line line;

        private ScatterBuilder(double[] x, double[] y) {
            this.x = x;
            this.y = y;
        }

        private ScatterBuilder(NumberColumn x, NumberColumn y) {
            this.x = x.asDoubleArray();
            this.y = y.asDoubleArray();
        }

        public ScatterBuilder mode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public ScatterBuilder line(Line line) {
            this.line = line;
            return this;
        }

        public ScatterBuilder marker(Marker marker) {
            this.marker = marker;
            return this;
        }

        public ScatterBuilder type(String kind) {
            this.type = kind;
            return this;
        }

        public ScatterBuilder text(String[] text) {
            this.text = text;
            return this;
        }

        public ScatterTrace build() {
            return new ScatterTrace(this);
        }

        @Override
        protected String getType() {
            return this.type;
        }

        @Override
        public ScatterBuilder name(String name) {
            return (ScatterBuilder)super.name(name);
        }

        @Override
        public ScatterBuilder opacity(double n) {
            Preconditions.checkArgument((n >= 0.0 && n <= 1.0 ? 1 : 0) != 0);
            return (ScatterBuilder)super.opacity(n);
        }

        @Override
        public ScatterBuilder legendGroup(String group) {
            return (ScatterBuilder)super.legendGroup(group);
        }

        @Override
        public ScatterBuilder showLegend(boolean showLegend) {
            return (ScatterBuilder)super.showLegend(showLegend);
        }

        @Override
        public ScatterBuilder visible(AbstractTrace.Visibility visibility) {
            return (ScatterBuilder)super.visible(visibility);
        }

        @Override
        public ScatterBuilder hoverLabel(HoverLabel hoverLabel) {
            return (ScatterBuilder)super.hoverLabel(hoverLabel);
        }
    }

    public static enum Mode {
        LINE("line"),
        MARKERS("markers"),
        LINE_AND_MARKERS("line + markers"),
        LINE_AND_TEXT("line + text"),
        TEXT_AND_MARKERS("text + text"),
        LINE_TEXT_AND_MARKERS("line + text + markers"),
        TEXT("text"),
        NONE("none");

        String value;

        private Mode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

