/*
 * Decompiled with CFR 0.152.
 */
package tech.skot.core;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.widget.ImageViewCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.skot.core.view.Color;
import tech.skot.core.view.ColorHex;
import tech.skot.core.view.ColorRef;
import tech.skot.core.view.Dimen;
import tech.skot.core.view.DimenDP;
import tech.skot.core.view.DimenRef;
import tech.skot.core.view.Icon;
import tech.skot.core.view.Resource;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u0010\u001a\u00020\u000f*\u00020\u00112\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0012"}, d2={"setBackground", "", "Landroid/view/View;", "resource", "Ltech/skot/core/view/Resource;", "setBackgroundTint", "color", "Ltech/skot/core/view/Color;", "setImageTint", "Landroid/widget/ImageView;", "setTint", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "toColor", "", "toPixelSize", "Ltech/skot/core/view/Dimen;", "viewlegacy_release"})
@SourceDebugExtension(value={"SMAP\nresourcesExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 resourcesExtensions.kt\ntech/skot/core/ResourcesExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class ResourcesExtensionsKt {
    public static final int toColor(@NotNull Color $this$toColor, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$toColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Color color = $this$toColor;
        return color instanceof ColorHex ? android.graphics.Color.parseColor((String)((ColorHex)$this$toColor).getColor()) : (color instanceof ColorRef ? ContextCompat.getColor((Context)context, (int)((ColorRef)$this$toColor).getRes()) : -1);
    }

    public static final void setBackground(@NotNull View $this$setBackground, @NotNull Resource resource) {
        Intrinsics.checkNotNullParameter((Object)$this$setBackground, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Resource resource2 = resource;
        if (resource2 instanceof Icon) {
            $this$setBackground.setBackgroundResource(((Icon)resource).getRes());
        } else if (resource2 instanceof Color) {
            Color color = (Color)resource;
            Context context = $this$setBackground.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this.context");
            $this$setBackground.setBackgroundColor(ResourcesExtensionsKt.toColor(color, context));
        }
    }

    public static final void setBackgroundTint(@NotNull View $this$setBackgroundTint, @Nullable Color color) {
        ColorStateList colorStateList;
        Intrinsics.checkNotNullParameter((Object)$this$setBackgroundTint, (String)"<this>");
        View view = $this$setBackgroundTint;
        Color color2 = color;
        if (color2 != null) {
            Color color3 = color2;
            View view2 = view;
            boolean bl = false;
            Context context = $this$setBackgroundTint.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this.context");
            colorStateList = ColorStateList.valueOf((int)ResourcesExtensionsKt.toColor(color, context));
            view = view2;
        } else {
            colorStateList = null;
        }
        view.setBackgroundTintList(colorStateList);
    }

    public static final void setImageTint(@NotNull ImageView $this$setImageTint, @Nullable Color color) {
        ColorStateList colorStateList;
        Intrinsics.checkNotNullParameter((Object)$this$setImageTint, (String)"<this>");
        ImageView imageView = $this$setImageTint;
        Color color2 = color;
        if (color2 != null) {
            Color color3 = color2;
            ImageView imageView2 = imageView;
            boolean bl = false;
            Context context = $this$setImageTint.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this.context");
            colorStateList = ColorStateList.valueOf((int)ResourcesExtensionsKt.toColor(color, context));
            imageView = imageView2;
        } else {
            colorStateList = null;
        }
        ImageViewCompat.setImageTintList((ImageView)imageView, colorStateList);
    }

    @NotNull
    public static final Drawable setTint(@NotNull Drawable $this$setTint, @NotNull Context context, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)$this$setTint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Drawable drawable = DrawableCompat.wrap((Drawable)$this$setTint);
        Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"wrap(this)");
        Drawable wrappedDrawable = drawable;
        DrawableCompat.setTint((Drawable)wrappedDrawable, (int)ResourcesExtensionsKt.toColor(color, context));
        return wrappedDrawable;
    }

    public static final int toPixelSize(@NotNull Dimen $this$toPixelSize, @NotNull Context context) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$toPixelSize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Dimen dimen = $this$toPixelSize;
        if (dimen instanceof DimenDP) {
            n = (int)((float)((DimenDP)$this$toPixelSize).getDp() * Resources.getSystem().getDisplayMetrics().density);
        } else if (dimen instanceof DimenRef) {
            n = context.getResources().getDimensionPixelSize(((DimenRef)$this$toPixelSize).getRes());
        } else {
            throw new Exception("Dimen.toPixelSize can only be used with " + Reflection.getOrCreateKotlinClass(DimenDP.class).getQualifiedName() + " and " + Reflection.getOrCreateKotlinClass(DimenRef.class).getQualifiedName() + ", create a custom extension for custom dimen " + Reflection.getOrCreateKotlinClass($this$toPixelSize.getClass()).getSimpleName());
        }
        return n;
    }
}

