/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

import tagbio.umap.FlatTree;
import tagbio.umap.Hyperplane;

class RandomProjectionTreeNode {
    private final int[] mIndices;
    private final Hyperplane mHyperplane;
    private final Float mOffset;
    private final RandomProjectionTreeNode mLeftChild;
    private final RandomProjectionTreeNode mRightChild;

    RandomProjectionTreeNode(int[] indices, Hyperplane hyperplane, Float offset, RandomProjectionTreeNode leftChild, RandomProjectionTreeNode rightChild) {
        this.mIndices = indices;
        this.mHyperplane = hyperplane;
        this.mOffset = offset;
        this.mLeftChild = leftChild;
        this.mRightChild = rightChild;
    }

    private boolean isLeaf() {
        return this.mLeftChild == null && this.mRightChild == null;
    }

    private int numNodes() {
        return 1 + (this.mLeftChild != null ? this.mLeftChild.numNodes() : 0) + (this.mRightChild != null ? this.mRightChild.numNodes() : 0);
    }

    private int numLeaves() {
        return this.isLeaf() ? 1 : this.mLeftChild.numLeaves() + this.mRightChild.numLeaves();
    }

    private int[] recursiveFlatten(Object hyperplanes, float[] offsets, int[][] children, int[][] indices, int nodeNum, int leafNum) {
        if (this.isLeaf()) {
            children[nodeNum] = new int[]{-leafNum, -1};
            indices[leafNum] = this.mIndices;
            return new int[]{nodeNum, leafNum + 1};
        }
        if (this.mHyperplane.shape().length > 1) {
            ((float[][][])hyperplanes)[nodeNum] = new float[][]{this.mHyperplane.data()};
        } else {
            ((float[][])hyperplanes)[nodeNum] = this.mHyperplane.data();
        }
        offsets[nodeNum] = this.mOffset.floatValue();
        int[] flattenInfo = this.mLeftChild.recursiveFlatten(hyperplanes, offsets, children, indices, nodeNum + 1, leafNum);
        children[nodeNum] = new int[]{nodeNum + 1, flattenInfo[0] + 1};
        return this.mRightChild.recursiveFlatten(hyperplanes, offsets, children, indices, flattenInfo[0] + 1, flattenInfo[1]);
    }

    private int maxSparseHyperplaneSize() {
        if (this.isLeaf()) {
            return 0;
        }
        return Math.max(this.mHyperplane.shape()[1], Math.max(this.mLeftChild.maxSparseHyperplaneSize(), this.mRightChild.maxSparseHyperplaneSize()));
    }

    FlatTree flatten() {
        Object hyperplanes;
        int nNodes = this.numNodes();
        int numLeaves = this.numLeaves();
        if (this.mHyperplane.shape().length > 1) {
            int maxHyperplaneNnz = this.maxSparseHyperplaneSize();
            hyperplanes = new float[nNodes][this.mHyperplane.shape()[0]][maxHyperplaneNnz];
        } else {
            hyperplanes = new float[nNodes][this.mHyperplane.shape()[0]];
        }
        float[] offsets = new float[nNodes];
        int[][] children = new int[nNodes][];
        int[][] indices = new int[numLeaves][];
        this.recursiveFlatten(hyperplanes, offsets, children, indices, 0, 0);
        return new FlatTree(hyperplanes, offsets, children, indices);
    }
}

