/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

import tagbio.umap.DefaultMatrix;
import tagbio.umap.Matrix;
import tagbio.umap.metric.Metric;
import tagbio.umap.metric.PrecomputedMetric;

public class PairwiseDistances {
    private PairwiseDistances() {
    }

    static Matrix pairwiseDistances(Matrix x, Metric metric) {
        if (PrecomputedMetric.SINGLETON.equals(metric)) {
            return x;
        }
        int n = x.rows();
        float[][] distances = new float[n][n];
        for (int k = 0; k < n; ++k) {
            float[] xk = x.row(k);
            for (int j = 0; j < n; ++j) {
                distances[k][j] = metric.distance(xk, x.row(j));
            }
        }
        return new DefaultMatrix(distances);
    }

    static Matrix pairwiseDistances(Matrix x, Matrix y, Metric metric) {
        if (PrecomputedMetric.SINGLETON.equals(metric)) {
            throw new IllegalArgumentException("Cannot use this method with precomputed");
        }
        int xn = x.rows();
        int yn = y.rows();
        float[][] distances = new float[xn][yn];
        for (int k = 0; k < xn; ++k) {
            float[] xk = x.row(k);
            for (int j = 0; j < yn; ++j) {
                distances[k][j] = metric.distance(xk, y.row(j));
            }
        }
        return new DefaultMatrix(distances);
    }
}

