/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

import java.util.Random;
import java.util.TreeSet;
import tagbio.umap.FlatTree;
import tagbio.umap.Heap;
import tagbio.umap.Matrix;
import tagbio.umap.SearchGraph;
import tagbio.umap.Utils;
import tagbio.umap.metric.Metric;

class NearestNeighborSearch {
    private final Metric mDist;

    NearestNeighborSearch(Metric dist) {
        this.mDist = dist;
    }

    void treeInit(FlatTree tree, Matrix data, Matrix queryPoints, Heap heap, Random random) {
        for (int i = 0; i < queryPoints.rows(); ++i) {
            int[] indices;
            for (int index : indices = tree.searchFlatTree(queryPoints.row(i), random)) {
                if (index < 0) continue;
                float d = this.mDist.distance(data.row(index), queryPoints.row(i));
                heap.push(i, d, index, true);
            }
        }
    }

    void randomInit(int nNeighbors, Matrix data, Matrix queryPoints, Heap heap, Random random) {
        for (int i = 0; i < queryPoints.rows(); ++i) {
            int[] indices;
            for (int index : indices = Utils.rejectionSample(nNeighbors, data.rows(), random)) {
                float d = this.mDist.distance(data.row(index), queryPoints.row(i));
                heap.push(i, d, index, true);
            }
        }
    }

    Heap initializedNndSearch(Matrix data, SearchGraph searchGraph, Heap initialization, Matrix queryPoints) {
        for (int i = 0; i < queryPoints.rows(); ++i) {
            int vertex;
            TreeSet<Integer> tried = new TreeSet<Integer>();
            for (int t : initialization.indices()[i]) {
                tried.add(t);
            }
            while ((vertex = initialization.smallestFlagged(i)) != -1) {
                for (int candidate : searchGraph.row(vertex)) {
                    if (candidate == vertex || candidate == -1 || tried.contains(candidate)) continue;
                    float d = this.mDist.distance(data.row(candidate), queryPoints.row(i));
                    initialization.uncheckedHeapPush(i, d, candidate, true);
                    tried.add(candidate);
                }
            }
        }
        return initialization;
    }
}

