/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

import java.util.Random;

class FlatTree {
    private static final float EPS = 1.0E-8f;
    private final Object mHyperplanes;
    private final float[] mOffsets;
    private final int[][] mChildren;
    private final int[][] mIndices;

    FlatTree(Object hyperplanes, float[] offsets, int[][] children, int[][] indices) {
        this.mHyperplanes = hyperplanes;
        this.mOffsets = offsets;
        this.mChildren = children;
        this.mIndices = indices;
    }

    int[][] getIndices() {
        return this.mIndices;
    }

    private static boolean selectSide(float[] hyperplane, float offset, float[] point, Random random) {
        float margin = offset;
        for (int d = 0; d < point.length; ++d) {
            margin += hyperplane[d] * point[d];
        }
        if (Math.abs(margin) < 1.0E-8f) {
            return random.nextBoolean();
        }
        return margin <= 0.0f;
    }

    int[] searchFlatTree(float[] point, Random random) {
        int node = 0;
        while (this.mChildren[node][0] > 0) {
            boolean side = FlatTree.selectSide(((float[][])this.mHyperplanes)[node], this.mOffsets[node], point, random);
            node = this.mChildren[node][side ? 1 : 0];
        }
        return this.mIndices[-this.mChildren[node][0]];
    }
}

